#!/bin/bash

host=$1
table=$2
partition=$3
dst_table=$(echo $table | sed 's/\(_v2\)\?_mergetree$/_v3_mergetree/')
hst=$(echo "$host" | sed 's/.$//')

source_cond=1
if clickhouse-client -q "DESC $table" | grep source; then
    source_cond="source NOT LIKE 'file:%dev%' AND source NOT LIKE 'file:%test%' AND source NOT LIKE 'file:ws6-029-30140%' AND source NOT LIKE 'file:sas1-9069-7120%'"
fi

year=$(echo $partition | grep -o '^[0-9][0-9][0-9][0-9]')
month=$(echo $partition | grep -o '[0-9][0-9]$')
rows_count=$(cat "/tmp/rows_count_${hst}_${table}_${partition}")
if [ -z "$rows_count" ]; then
    rows_count=$(clickhouse-client -h "$host" -ureadonly -q "SELECT COUNT(*) FROM $table WHERE toYear(log_date) = $year AND toMonth(log_date) = $month AND $source_cond")
    printf %s "$rows_count" > "/tmp/rows_count_${table}_${partition}"
fi
if [ "$4" = "check" ]; then
    set -x
    set -e
    diff -u <(clickhouse-client -h$host -ureadonly -q "SELECT log_date, COUNT(*) FROM $table WHERE toYear(log_date) = $year AND toMonth(log_date) = $month AND $source_cond GROUP BY log_date") <(clickhouse-client -q "SELECT log_date, COUNT(*) FROM $dst_table WHERE toYear(log_date) = $year AND toMonth(log_date) = $month GROUP BY log_date")
    exit 0
fi
if clickhouse-client -q "SELECT COUNT(*) FROM $table WHERE toYear(log_date) = $year AND toMonth(log_date) = $month AND $source_cond" | grep '[0-9]'; then
    printf "$table: parition $partition is not empty, exiting"
    exit 1
fi
clickhouse-client -h "$host" -ureadonly -q "SELECT * FROM $table WHERE toYear(log_date) = $year AND toMonth(log_date) = $month AND $source_cond" | ( ./clh-insert-data.py $dst_table 2>&1 | sed "s,\$,/$rows_count," ) >> "pcopy-$hst-$table-$partition-$(date +%Y%m%dT%H%M).log"
