#!/usr/bin/python

import logging
import os
import re
import subprocess
import sys

logging.basicConfig(level=logging.DEBUG, format='%(asctime)s %(message)s')

table = sys.argv[1]
if not re.search(r'_mergetree$', table):
    sys.exit('table name must end with _mergetree')

limit = int(os.environ.get('INSERT_ROWS_LIMIT', 500000))
line = ''
line_count = 0
total_line_count = 0
p = None
logging.info('rows limit: %s' % limit)
while line != '' or line_count == 0:
    line = sys.stdin.readline()
    if not p or line_count >= limit:
        if p:
            p.stdin.close()
            p.wait()
        p = subprocess.Popen(['clickhouse-client', '-q', 'INSERT INTO {} FORMAT TSV'.format(table)], stdin=subprocess.PIPE)
        total_line_count += line_count
        logging.info('rows sent: {}'.format(total_line_count))
        line_count = 0
    p.stdin.write(line)
    line_count += 1
