#!/usr/bin/python
# -*- coding: utf-8 -*-
# vim: set expandtab ts=4 sw=4:
# $Id$

import argparse
import re
import os
import subprocess
import sys

def ssh_clickhouse(host, query):
    sys.stderr.write('{}: {}\n'.format(host, query))
#    if 'ALTER' in query or 'alter' in query:
#        return
    p = subprocess.Popen(['ssh', '-o', 'StrictHostKeyChecking=no', host, 'clickhouse-client'], stdin=subprocess.PIPE, stdout=subprocess.PIPE)
#    p = subprocess.Popen(['ssh', '-o', 'StrictHostKeyChecking=no', host, 'clickhouse-client', '-u', 'readonly'], stdin=subprocess.PIPE, stdout=subprocess.PIPE)
    rows = []
    p.stdin.write(query)
    p.stdin.close()
    for line in p.stdout.readlines():
        rows.append(line.rstrip())
    return rows

def run():
    parser = argparse.ArgumentParser()
    parser.add_argument('src_host')
    parser.add_argument('table')
    parser.add_argument('dst_host')
    args = parser.parse_args()
    mergetree_table_v1 = args.table + '_mergetree'
    mergetree_table_v2 = args.table + '_v2_mergetree'
    mergetree_table_v3 = args.table + '_v3_mergetree'
    src_shard = re.match(r'ppchouse(0[0-9])', args.src_host).group(1)
    hs = ssh_clickhouse('ppchouse01k.yandex.ru', "SELECT host_name FROM system.clusters WHERE host_name != 'localhost' ORDER BY host_name")
    hosts = [hs[i*3] for i in xrange(len(hs) / 3)]
    partitions = set()
    partitions_v3 = set()
    for host in hosts:
        for p in ssh_clickhouse(host, "SELECT DISTINCT(partition) FROM system.parts WHERE table = '{}' OR table = '{}' AND active".format(mergetree_table_v1, mergetree_table_v2)):
            partitions.add(p)
        for p in ssh_clickhouse(host, "SELECT DISTINCT(partition) FROM system.parts WHERE table = '{}' AND active".format(mergetree_table_v3)):
            partitions_v3.add(p)
    partitions_on_source_host = set(ssh_clickhouse(args.src_host, "SELECT DISTINCT(partition) FROM system.parts WHERE table = '{}' AND active".format(mergetree_table_v3)))
    partitions_to_skip = set(['201705', '201512', '201612'])
    partitions_to_move = ((partitions - partitions_v3) - partitions_to_skip) & partitions_on_source_host
#    partitions_to_move = set(['201508'])
    for p in sorted(list(partitions_to_move)):
        ssh_clickhouse(args.dst_host, "ALTER TABLE {} FETCH PARTITION '{}' FROM '/clickhouse/tables/{}/{}'".format(mergetree_table_v3, p, src_shard, mergetree_table_v3))
        ssh_clickhouse(args.dst_host, "ALTER TABLE {} ATTACH PARTITION '{}'".format(mergetree_table_v3, p))
        for host in hosts:
            for t in [mergetree_table_v1, mergetree_table_v2]:
                ssh_clickhouse(host, "ALTER TABLE {} DETACH PARTITION '{}'".format(t, p))

if __name__ == '__main__':
    run()

