#!/usr/bin/python

from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer
import json

class S(BaseHTTPRequestHandler):
    def _set_headers(self):
        self.send_response(200)
        self.send_header('Content-type', 'application/json')
        self.end_headers()

    def do_GET(self):
        res = {}
        if self.path == "/gorynych_ng_frontends_prod?format=json":
            res = [{'fqdn': '2a02:6b8:0:1448:7b04:ee5a:6c1:f958'}, 
                    {'fqdn': '2a02:6b8:0:1a4a:f4a3:949:3ab:7c30'},
                    {'fqdn': '2a02:6b8:0:2504:2ce4:76b4:476e:faea'}, 
                    {'fqdn': '37.140.140.209'}, {'fqdn': '37.9.126.157'}]
        if not res:
            self.send_response(404)
        else:
            self._set_headers()
            self.wfile.write(json.dumps(res).encode('utf-8'))

    def do_HEAD(self):
        self._set_headers()
        
        
def run(server_class=HTTPServer, handler_class=S, port=8000):
    server_address = ('', port)
    httpd = server_class(server_address, handler_class)
    print 'Starting fake conductor...'
    httpd.serve_forever()

if __name__ == "__main__":
    from sys import argv

    if len(argv) == 2:
        run(port=int(argv[1]))
    else:
        run()