#!/bin/bash

CODE=0
PATH_TO_SCRIPT=`perl -e '$ARGV[0] =~ s![^/]*$!!; print $ARGV[0]' $0`
for VER in 5.5 5.6 5.7; do # add versions here
    echo "tests for version $VER..."
    docker pull mysql/mysql-server:$VER > /dev/null 2>&1
    I=`docker run --name compare-grants-test-$VER -e MYSQL_ROOT_PASSWORD='pass' -e MYSQL_ROOT_HOST='%' -P -d mysql/mysql-server:$VER`
    P=`docker inspect compare-grants-test-$VER | grep '3306/tcp' -A3 | grep HostPort | perl -e '$_ = <>; $_ =~ s/^.*\: \"(\d+)\"/$1/;print $_'`
    if [ -z "$P" ]; then
        echo "Docker failed to start" 1>&2
        exit -1
    fi
    CONDUCTOR_PID=`$PATH_TO_SCRIPT"conductor_server.py" $(( P + 2 )) > /dev/null 2>&1 & echo $!`
    while true; do
        MYSQL_PWD="pass" mysql --host=127.0.0.1 --port=$P --user=root -e 'select now();' > /dev/null 2>&1
        if (( $? == 0 )); then
            break
        fi
        sleep 1
    done
    MYSQL_PWD="pass" mysql --host=127.0.0.1 --port=$P --user=root -e 'create database db;' > /dev/null
    if [ $? -ne 0 ]; then exit 1; fi
    ls $PATH_TO_SCRIPT$VER > /dev/null
    if [ $? -ne 0 ]; then exit 1; fi
    for test in `ls $PATH_TO_SCRIPT$VER`; do
        MYSQL_PWD="pass" $PATH_TO_SCRIPT"do_one_test.py" --port $(( P + 2 )) --version $VER --test $test --mysql-params "\-\-host=127.0.0.1 \-\-port=$P \-\-user=root"
        if [ $? -ne 0 ]; then
            CODE=$(( CODE + 1 ))
            echo $test "FAILED"
        else
            echo $test "OK"
        fi

    done
    kill -s 15 "$CONDUCTOR_PID" > /dev/null 2>&1
    if [ "$?" -ne "0" ]; then
        CODE=$((CODE + 1))
        echo "Error. fake conductor $CONDUCTOR_PID is down!" 1>&2
    fi
    docker stop compare-grants-test-$VER > /dev/null
    docker rm compare-grants-test-$VER  > /dev/null
done
if [ $CODE -ne 0 ]; then
    echo "Failed $CODE tests."
else
    echo "All tests passed."
fi
exit $CODE
