#!/usr/bin/perl

=for none

фигурное редактирование поля offer_examples из feeds

=cut

use strict;
use warnings;
use lib '/var/www/ppc.yandex.ru/';
use my_inc '/var/www/ppc.yandex.ru', for => 'protected';

use YAML;
use JSON;

use Yandex::DBTools;

use Settings;

use utf8;
use open ':std' => ':utf8';

# с какой базой работаем
BEGIN { $ENV{SETTINGS_LOCAL_SUFFIX} = 'DevTest'; }


my $feed_id = 244426;

# выбираем исходные данные
my $arr = get_one_column_sql(PPC(shard => 'all'), 
    [
        "select offer_examples from feeds", 
        where => { feed_id => $feed_id }
    ]);

# пишем, как они выглядели
my $json_orig = $arr->[0];
print "original json: $json_orig\n";

# десериализуем
my $data = from_json($json_orig);
print YAML::Dump($data);

# здесь можно какое хочешь редактирование
$data->{data_params}->{'MOW–AER'} = {c => 8};
# варианты:
#$data->{data_params}->{'MOW–AER'} = {};
#$data->{data_params}->{'MOW–AER'} = '';
#delete $data->{data_params}->{'MOW–AER'};

# Дальше типовая обработка
# сериализуем обратно
my $json_new = to_json($data);

# пишем, как выглядит новый json
print "updated json: $json_new\n";
print YAML::Dump($data);

# обновляем БД
do_update_table(PPC(shard => 'all'), "feeds", {offer_examples => $json_new}, where => {feed_id => $feed_id});

