#!/usr/bin/perl

use Data::Dumper; 
use YAML;
use JSON;
use utf8;

use Yandex::Staff3 qw(get_staff_info_ext);
use Yandex::ABC qw(get_data_from_abc);
use List::MoreUtils qw/uniq/;

use open ":std" => ":utf8";

# пользоваться так: dev/get-ssh-keys.pl > data/direct/ts-updater-keys/staff

# Скрипт для скачивания ssh-ключей со стаффа, потом их можно добавлять в bin/add-del-updater-user-keys.pl
# печатает списки ключей для каждого неуволенного сотрудника Директа

$Data::Dumper::Sortkeys = 1;

my $fields = 'department_group.name,phones.number,name.first,name.last,login,keys.key,official.is_dismissed';
my $direct_staff = get_staff_info_ext('persons', (_limit => 500,
        'official.is_dismissed' => 'false',
        'department_group.ancestors.name' => 'Директ',
        _fields => $fields));

my $staff_leaders = get_staff_info_ext('persons', (_limit => 500,
        'official.is_dismissed' => 'false',
        'groups.group.name' => 'Директ',
        _fields => $fields));

my $staff_mod = get_staff_info_ext('persons', (_limit => 500,
        'official.is_dismissed' => 'false',
        'groups.group.name' => 'Группа разработки модерации рекламы',
        _fields => $fields));
                                                                                              
my $staff_special = get_staff_info_ext('persons', (_limit => 500,
        'official.is_dismissed' => 'false',
        'login' => 'ppc,mirage,robot-irt-jenkins,kosmana,violg,poroshin-ivan',
        _fields => $fields));

push @$direct_staff, @$staff_leaders;
push @$direct_staff, @$staff_mod;
push @$direct_staff, @$staff_special;

# добавляем разработчиков, состоящих в проекте в ABC, но далеких по стаффу
my %logins_from_staff = map {$_->{login} => 1} @{$direct_staff};
my $abc_direct = get_data_from_abc('services/members', (service__slug => 'direct', role__code => 'developer', fields => 'person.login'));
my @new_logins_from_abc = uniq grep {!$logins_from_staff{$_}} map {$_->{person}->{login}} @{$abc_direct};

my $staff_abc_special = get_staff_info_ext('persons', (_limit => 500,
        'official.is_dismissed' => 'false',
        'login' => join(",", @new_logins_from_abc),
        _fields => $fields));

push @$direct_staff, @$staff_abc_special;

#my $direct_staff_groups = [
#    'Отдел разработки Директа',
#    'Группа разработки модерации рекламы',
#];
#my $direct_staff_groups_re = join "|", @$direct_staff_groups;
#my $special_logins_re = qr!^(mirage|ppc)$!;


if(0){
# Имена и телефоны
for my $p ( @$direct_staff ){
    next unless @{$p->{phones}||[]};
    my $i = 1;
    for my $f (qw/first_name last_name/){
        $p->{$f} =~ s/^\s+//;
        $p->{$f} =~ s/\s.*//;
    }
    for ( @{$p->{phones}} ){
        $_->{number} =~ s/[^0-9+]//g;
        $_->{number} =~ s/^8/+7/g;
        print "$_->{number} $p->{first_name} $p->{last_name}". ( $i > 1 ? "-$i" : "") ."\n";
        $i++;
    }
}
exit;
}

#print to_json($direct_staff, {pretty => 1}); 
my %k = (); 
for (@$direct_staff) { 
    next unless @{$_->{keys}||[]}; 
    $k{$_->{login}} = [map {$_->{key}} @{$_->{keys}||[]} ]; 
    $k{$_->{login}} = $k{$_->{login}}->[0] if @{$k{$_->{login}}} == 1; 
} 
print YAML::Dump( \%k ); 
