#!/bin/bash -e

wc_revision=$(LC_ALL=C svn info | awk '/^Revision:/ {print $2}')
svn_url=$(LC_ALL=C svn info | awk '/^URL:/ {print $2}')
repo_revision=$(LC_ALL=C svn info ${svn_url?"couldn't get repo url"} | awk '/^Revision:/ {print $2}')
if [ ${wc_revision?"couldn't get working copy rev"} != ${repo_revision?"couldn't get repo rev"} ]
then
    echo "working copy is out of date, won't sync"
    exit 1
fi
set -e
svn-verify-working-copy
set +e

cd ./data
find . -type f -not -name '.*' |sed 's!^./!!' | while read f ; do echo $f ; curl -XPUT --data-binary @$f 'http://localhost:8500/v1/kv/'$f ; done

