--ya yql -i moat.sql -f csv --show-only-errors --no-column-types --no-column-names hahn > moat.csv
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

--расхождения с моатом по показам за неделю
$format = DateTime::Format("%Y-%m-%d");

$data = select * from range('//home/bs/users/yabs-analytics/reach/verificator_dashboard/prod/moat/discrepancy_debug',
    --'2021-09-10T07:00:00_2021-09-11T06:00:00',
    $format(CurrentUtcDate()- DateTime::IntervalFromDays(7))||'T07:00:00_'||$format(CurrentUtcDate()- DateTime::IntervalFromDays(6))||'T06:00:00',
    $format(CurrentUtcDate()- DateTime::IntervalFromDays(1))||'T07:00:00_'||$format(CurrentUtcDate())||'T06:00:00');

$discrepancy_debug = (
    select
        cid,
        
        some(moat_cid) as moat_cid,
        some(adgroup_type) as adgroup_type,
        
        sum(shows_good) as shows_good,
        sum(shows_all) as shows_all,
        sum(inview_sum) as inview_sum,

        sum(shows_good_not_adb) as shows_good_not_adb,
        sum(shows_good_not_adb_in_app) as shows_good_not_adb_in_app,
        sum(shows_good_not_adb_old) as shows_good_not_adb_old,
        sum(shows_good_main) as shows_good_main,
        sum(shows_good_not_in_app) as shows_good_not_in_app,
        sum(shows_good_not_in_app_old) as shows_good_not_in_app_old,
        sum(shows_good_not_old) as shows_good_not_old,
        sum(shows_good_not_ssp) as shows_good_not_ssp,
        sum(shows_good_not_smart_tv) as shows_good_not_smart_tv,

        sum(shows_all_not_adb) as shows_all_not_adb,
        sum(shows_all_not_adb_in_app) as shows_all_not_adb_in_app,
        sum(shows_all_not_adb_old) as shows_all_not_adb_old,
        sum(shows_all_main) as shows_all_main,
        sum(shows_all_not_in_app) as shows_all_not_in_app,
        sum(shows_all_not_in_app_old) as shows_all_not_in_app_old,
        sum(shows_all_not_old) as shows_all_not_old,
        sum(shows_all_not_ssp) as shows_all_not_ssp,
        sum(shows_all_not_smart_tv) as shows_all_not_smart_tv,

        sum(inview_sum_not_adb) as inview_sum_not_adb,
        sum(inview_sum_not_adb_in_app) as inview_sum_not_adb_in_app,
        sum(inview_sum_not_adb_old) as inview_sum_not_adb_old,
        sum(inview_sum_main) as inview_sum_main,
        sum(inview_sum_not_in_app) as inview_sum_not_in_app,
        sum(inview_sum_not_in_app_old) as inview_sum_not_in_app_old,
        sum(inview_sum_not_old) as inview_sum_not_old,
        sum(inview_sum_not_ssp) as inview_sum_not_ssp,
        sum(inview_sum_not_smart_tv) as inview_sum_not_smart_tv
    from
        $data
    where 
        moat_cid = 1
    group by
        cid
);

$debug_const__dif = 0.1;
$debug_const__shows = 100000;
$debug_const__prior = 100;
$_dif = ($r, $key, $event) -> {
    return (
            Unwrap(cast(TryMember($r, $event || '_' || $key, null) as Double)) -
            Unwrap(cast(TryMember($r, 'shows_good' || '_' || $key, null) as Double))
        ) * 1. / (Unwrap(cast(TryMember($r, 'shows_good' || '_' || $key, null) as Double)) + $debug_const__prior)
};
$_dif_fraud = ($r, $key, $event) -> {
    return (
            Unwrap(cast(TryMember($r, $event || '_' || $key, null) as Double)) -
            Unwrap(cast(TryMember($r, 'shows_all' || '_' || $key, null) as Double))
        ) * 1. / (Unwrap(cast(TryMember($r, 'shows_all' || '_' || $key, null) as Double)) + $debug_const__prior)
};
$_dif_metric = ($r, $metric, $event) -> {
    return (
            Unwrap(cast(TryMember($r, $event, null) as Double)) -
            Unwrap(cast(TryMember($r, $metric, null) as Double))
        ) * 1. / (Unwrap(cast(TryMember($r, $metric, null) as Double)) + $debug_const__prior)
};
$debug = ($r, $event) -> {
    $dif = $_dif_metric($r, 'shows_good', $event);
    return
    --Есть расхождение
    if (Math::Abs($dif) > $debug_const__dif and $r.shows_good > $debug_const__shows,
    --Расхождение в сторону Директа
    if($r.moat_cid = 0, 'Не включен верификатор на заказе',
    if($dif < 0 and Math::Abs($_dif($r, 'not_ssp', $event)) < $debug_const__dif, 'SSP',
    if($dif < 0 and Math::Abs($_dif($r, 'not_smart_tv', $event)) < $debug_const__dif, 'SmartTV',
    if($dif < 0 and Math::Abs($_dif($r, 'not_in_app', $event)) < $debug_const__dif, 'INAPP',
    if($dif < 0 and Math::Abs($_dif($r, 'not_old', $event)) < $debug_const__dif, 'Старая версия ПП',
    if($dif < 0 and Math::Abs($_dif($r, 'not_adb', $event)) < $debug_const__dif, 'АнтиАдблок',
    if($dif < 0 and Math::Abs($_dif($r, 'not_in_app_old', $event)) < $debug_const__dif, 'INAPP + Старая версия ПП',
    if($dif < 0 and Math::Abs($_dif($r, 'not_adb_old', $event)) < $debug_const__dif, 'АнтиАдблок + Старая версия ПП',
    if($dif < 0 and Math::Abs($_dif($r, 'not_adb_in_app', $event)) < $debug_const__dif, 'INAPP + АнтиАдблок',
    if($dif < 0 and Math::Abs($_dif($r, 'main', $event)) < $debug_const__dif, 'SSP + INAPP + SmartTV + АнтиАдблок + Старая версия ПП',
    --Расхождение в сторону верификатора
    if($dif > 0 and $_dif_metric($r, 'shows_all', $event) < $debug_const__dif, 'Фрод',
    if($_dif($r, 'not_ssp', $event) > 0 and $_dif_fraud($r, 'not_ssp', $event) < $debug_const__dif, 'SSP + Фрод',
    if($_dif($r, 'not_smart_tv', $event) > 0 and $_dif_fraud($r, 'not_smart_tv', $event) < $debug_const__dif, 'SmartTV + Фрод',
    if($_dif($r, 'not_in_app', $event) > 0 and $_dif_fraud($r, 'not_in_app', $event) < $debug_const__dif, 'INAPP + Фрод',
    if($_dif($r, 'not_old', $event) > 0 and $_dif_fraud($r, 'not_old', $event) < $debug_const__dif, 'Старая версия ПП + Фрод',
    if($_dif($r, 'not_adb', $event) > 0 and $_dif_fraud($r, 'not_adb', $event) < $debug_const__dif, 'АнтиАдблок + Фрод',
    if($_dif($r, 'not_in_app_old', $event) > 0 and $_dif_fraud($r, 'not_in_app_old', $event) < $debug_const__dif, 'INAPP + Старая версия ПП + Фрод',
    if($_dif($r, 'not_adb_old', $event) > 0 and $_dif_fraud($r, 'not_adb_old', $event) < $debug_const__dif, 'АнтиАдблок + Старая версия ПП + Фрод',
    if($_dif($r, 'not_adb_in_app', $event) > 0 and $_dif_fraud($r, 'not_adb_in_app', $event) < $debug_const__dif, 'INAPP + АнтиАдблок + Фрод',
    if($_dif($r, 'main', $event) > 0 and $_dif_fraud($r, 'main', $event) < $debug_const__dif, 'SSP + INAPP + SmartTV + АнтиАдблок + Старая версия ПП + Фрод',
    'Неизвестная причина')))))))))))))))))))), 'Нет расхождения')
};

select $format(CurrentUtcDate()) as dt, c.cid as cid, c.name as name,
    stat.yndx_shows as yndx_shows,
    stat.moat_events as moat_imp,
    stat.adgroup_type as adgroup_type
from (select shows_good_main as yndx_shows,
    inview_sum_main as moat_events,
    adgroup_type as adgroup_type,
    cid
    from $discrepancy_debug
    where $debug(TableRow(), 'inview_sum') = 'Неизвестная причина') as stat
inner join like(`//home/direct/mysql-sync/current`, `ppc:%`, `straight/campaigns`) as c on c.cid=stat.cid
order by yndx_shows desc
