#!/usr/bin/perl

=head1 DESCRIPTION

=head1 EXAMPLES

compare_debs.pl /home/lena-san/direct-release-current/packages /home/lena-san/temporary-working-copies/trunk/packages 
compare_debs.pl /home/lena-san/direct-release-current/packages /home/lena-san/temporary-working-copies/trunk/packages -p yandex-direct-mysql-ppcdata3

=cut

use strict;
use warnings;

use File::Temp qw/tempdir/;
use Getopt::Long;
use YAML;

my $VERBOSE = 0;

run() unless caller();

sub run
{
    my $opt = parse_options();

    my ($dir1, $dir2) = ($ARGV[0], $ARGV[1]);
    my $debs;
    $debs->[1] = [ glob("$dir1/*.deb") ];
    $debs->[2] = [ glob("$dir2/*.deb") ];
    my $tempdir = tempdir( "/tmp/compare_debs_XXXXXXXX" );
    print "tmp dir: $tempdir\n";
    #my $tempdir = "compare_debs";
    mkdir $tempdir;
    -d $tempdir or die "can't create tempdir $tempdir";
    print YAML::Dump($debs) if $VERBOSE;
    
    for my $i (1 .. 2){
        my $dir = "$tempdir/$i";
        mkdir $dir or die;
        mkdir "$dir/data" or die;
        mkdir "$dir/metadata" or die;
        for my $deb_file ( @{$debs->[$i]} ){
            $deb_file =~ m!.*/(.*?)_.*!;
            my $package = $1;
            next if keys %{$opt->{only_packages}} && !$opt->{only_packages}->{$package};
            ex("dpkg -x $deb_file $dir/data/$package");
            ex("dpkg -e $deb_file $dir/metadata/${package}");
            ex("rm -f $dir/metadata/${package}/md5sums");
            ex("rm -f $dir/data/$package/usr/share/doc/$package/copyright");
            ex("rm -rf $dir/data/$package/usr/share/lintian");
            ex("rm -f $dir/data/$package/usr/share/doc/$package/changelog.Debian.gz");
        }
    }
    ex("diff -ru $tempdir/{1,2}");
    print "\nполезные команды:\ndiff -ru $tempdir/{1,2}\ndiff -ru $tempdir/{1,2}/data\nпотом удали каталог $tempdir , пожалуйста\n";
}

sub ex
{
    my $cmd = shift;
    print "$cmd\n" if $VERBOSE;
    system($cmd);
}

sub parse_options
{
    my %O;
    my $packages = [];
    GetOptions(
        "help" => sub {
            system("podselect -section NAME -section DESCRIPTION -section OPTIONS -section EXAMPLES $0 | pod2text");
            exit 0;
        },
        "p|only-package=s@" => $packages,
    ) || die "can't parse options, stop";

    $packages ||= [];
    $O{only_packages} = { map { $_ => 1} @$packages };

    return \%O;
}

