#!/usr/bin/python
# -*- coding: utf8 -*-

import unittest
import os.path
import sys
dr = os.path.dirname(__file__)
sys.path.append(os.path.join(dr, '..', 'bin'))
import importlib
import yaml
deploy_consistency = importlib.import_module('deploy-consistency-monitor')


def get_subtests(f):
    with open(f, 'r') as f:
        return yaml.load(f)


class TestCmp(unittest.TestCase):
    def test_cmp(self):
        subtests = get_subtests(dr+'/cmp_tests.yaml')
        for test in subtests:
            deploy_consistency.logger = deploy_consistency.set_logger()
            #print logger
            self.assertEqual(deploy_consistency.cmp_versions('ZK|LP',
                                                             test,
                                                            subtests[test]['version_zk'],
                                                            deploy_consistency.convert_dt_zk(subtests[test]['dt_zk']),
                                                            subtests[test]['version_dpkg'],
                                                            deploy_consistency.convert_dt_zk(subtests[test]['dt_now']),
                                                            )[0],
                subtests[test]['expected'])


if __name__ == '__main__':
    unittest.main()
