#!/bin/sh

host=$1
port=$2

# root нужен для traceroute -T
if [ `whoami` != 'root' ]; then printf "error: must be run as root\n"; exit 1; fi
if [ -z "$host" ] || [ -z "$port" ]; then printf "Usage: $0 <host> <port>\n"; exit 1; fi

set -x
date +'%Y-%m-%d %H:%M:%S'
ping6 -c 10 "$host"
date +'%Y-%m-%d %H:%M:%S'
traceroute -6 "$host"
date +'%Y-%m-%d %H:%M:%S'
sudo traceroute -6 -T -p "$port" "$host"
date +'%Y-%m-%d %H:%M:%S'
nc.openbsd -6 -vzw 10 "$host" "$port"
date +'%Y-%m-%d %H:%M:%S'
set +x

