#!/usr/bin/perl

=head1 check-configs.t

    Минимально проверяет синтаксис конфигов

=cut

use Direct::Modern;

use Test::More;
use Test::Exception;

use YAML qw(LoadFile);
use FindBin qw($Bin);
use File::Find;

ok(1, "phony test");
my $CONFIG_DIR = "$Bin/../etc/direct-access-check";
find(\&_check_config, $CONFIG_DIR);

done_testing;

=head3 _check_config

=cut

sub _check_config {
    my $file = $_;

    return unless -e $file && $file =~ /^.*\.yaml$/;

    lives_ok { LoadFile($file) } "valid YAML in $file";
}
