#!/usr/bin/perl

=head1 check-configs.t

    Проверяет:
      - минимально синтаксис конфигов
      - наличие и валидность juggler_event_name для каждого элемента списка

=cut

use Direct::Modern;

use Test::More;
use Test::Exception;

use YAML qw(LoadFile);
use FindBin qw($Bin);
use File::Find;

our $ENTRY_NAME_RE = '^[a-z0-9_.\-]+$';

my $CONFIG_DIR = "$Bin/../etc/direct-access-check";
find(\&_check_config, $CONFIG_DIR);

done_testing;

=head3 _check_config

=cut

sub _check_config {
    my $file = $_;

    return unless -e $file;

    my $config;
    lives_ok { $config = LoadFile($file) } "valid YAML in $file";
    for my $index (0..$#$config) {
        my $item = $config->[$index];
        ok(exists $item->{juggler_event_name}, qq/juggler_event_name is present for item #$index/);
        ok($item->{juggler_event_name} =~ /$ENTRY_NAME_RE/, qq/juggler_event_name "$item->{juggler_event_name}" at item #$index matches $ENTRY_NAME_RE/);
    }
}
