# -*- coding: utf-8 -*-
import copy
import json
import logging
from juggler_sdk import JugglerApi
from juggler_sdk.check_sync import FullCheckDifference

# копипаста из svn direct-utils/directadmin-juggler-checks/directadmon/juggler_helpers.py

def process_upsert_result(res, check, pretty):
    changes_type = 'not_changed'
    if res.changed:
        changes_type = 'updated'
        if isinstance(res.diff, FullCheckDifference):
            changes_type = 'inserted'
        log_info_v("check %s: (%s) %s:%s, diff: %s" % (changes_type, check.namespace, check.host, check.service, jdumps(res.diff.to_dict(), pretty)))
    else:
        log_info_vv("check %s: (%s) %s:%s" % (changes_type, check.namespace, check.host, check.service))

    return changes_type
 

def apply_checks(all_checks, mark, token, dry_run=True, pretty=False):
    changes_cnt = {'not_changed': 0, 'updated': 0, 'inserted': 0, 'removed': 0}

    with JugglerApi('http://juggler-api.search.yandex.net', mark=mark, oauth_token=token, dry_run=dry_run) as api:
        for check in all_checks:
            log_info_vv('trying to upsert check: (%s) %s:%s' % (check.namespace, check.host, check.service))
            log_info_vvv('raw check: ' + jdumps(check.to_dict(), pretty))
            res = api.upsert_check(check)

            changes_type = process_upsert_result(res, check, pretty)
            changes_cnt[changes_type] += 1

        cres = api.cleanup()
        for host, service in cres.removed:
            changes_cnt['removed'] += 1
            log_info_v("check removed: %s:%s" % (host, service))
 
    total = len(all_checks) + changes_cnt['removed']
    changes_cnt['changed'] = total - changes_cnt['not_changed']
    changes_str = 'changed: %3d (%s)' % (
        changes_cnt['changed'],
        ', '.join(['%s: %3d' % (k, changes_cnt[k]) for k in ('inserted', 'updated', 'removed')])
    )
    log_info(', '.join(['dry_run: ' + str(dry_run), changes_str, 'total: ' + str(total)]))

    return changes_cnt


def log_info(msg, *args, **kwargs):
    logging.getLogger(__name__).log(logging.INFO - 0, msg, *args, **kwargs)
def log_info_v(msg, *args, **kwargs):
    logging.getLogger(__name__).log(logging.INFO - 1, msg, *args, **kwargs)
def log_info_vv(msg, *args, **kwargs):
    logging.getLogger(__name__).log(logging.INFO - 2, msg, *args, **kwargs)
def log_info_vvv(msg, *args, **kwargs):
    logging.getLogger(__name__).log(logging.INFO - 3, msg, *args, **kwargs)


def jdumps(jdict, pretty=False):
    def serialize(obj):
        try:
            s = obj.__dict__
        except:
            s = obj
        return s
 
    if pretty:
        return '\n' + json.dumps(jdict, sort_keys=True, ensure_ascii=False, indent=4, separators=(',', ': '), default=serialize)
    return json.dumps(jdict, sort_keys=True, ensure_ascii=False, default=serialize)


def hash_merge(*dict_args):
    result = {}
    for d in dict_args:
        for key, value in d.iteritems():
            if isinstance(value, dict):
                result[key] = hash_merge(result.get(key, {}), value)
            else:
                result[key] = copy.deepcopy(value)
    return result
