from __future__ import absolute_import

import sys
import types as sys_types
import importlib

__revision__ = 3994510

# TODO: crutch for skynet service clients. Remove after SKYDEV-1223, SKYDEV-1237
try:
    import gevent
    try:
        import gevent.lock
        gevent.coros = sys.modules["gevent.coros"] = gevent.lock
    except ImportError:
        # noinspection PyUnresolvedReferences
        import gevent.coros
        gevent.lock = sys.modules["gevent.lock"] = gevent.coros
except ImportError:
    pass

# noinspection PyUnreachableCode
if False:
    # This block has absolutely no practical sense, but it allows PyCharm to navigate over lazy-loaded symbols.
    import common.api
    import common.atfork
    import common.joint
    import common.test
    import common.types
    import common.vcs

    import common.config
    import common.console
    import common.crypto
    import common.daemon
    import common.errors
    import common.fs
    import common.hash
    import common.import_hook
    import common.log
    import common.mds
    import common.name_generator
    import common.os
    import common.package
    import common.patterns
    import common.platform
    import common.process
    import common.profiler
    import common.projects_handler
    import common.proxy
    import common.quicksearch
    import common.rest
    import common.share
    import common.staff
    import common.statistics
    import common.telegram
    import common.threading
    import common.upload
    import common.utils
    import common.zk  # noqa
    import common.collections
    import common.lazy  # noqa


def __alias(modname):
    this_mod = sys.modules[__name__]
    full_name = ".".join([__name__, modname])

    def replace_sym(name):
        mod = importlib.import_module("." + modname, __name__)
        setattr(this_mod, name, mod)
        return mod

    class AliasModule(sys_types.ModuleType):
        def __repr__(self):
            return "<AliasModule {!r}>".format(full_name)

        def __getattr__(self, name):
            return getattr(replace_sym(name), name)

        def __setattr__(self, name, value):
            setattr(replace_sym(name), name, value)

        def __delattr__(self, name):
            delattr(replace_sym(name), name)

    setattr(this_mod, modname, AliasModule(full_name))


map(
    __alias,
    "api atfork joint test types vcs "
    "config console crypto daemon errors fs hash import_hook log mds name_generator "
    "os package patterns platform process profiler projects_handler proxy quicksearch "
    "rest share staff statistics telegram threading upload utils zk collections lazy".split()
)
