package ru.yandex.sandbox.client.retrofit;

import java.io.IOException;
import java.lang.reflect.Type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.io.IOUtils;
import retrofit.mime.TypedInput;

/**
 * This is replacement of {@link retrofit.converter.JacksonConverter}.
 * The converter saves response body inside exceptions
 *
 * @author albazh
 */
public class JacksonConverterKeepingResponse extends retrofit.converter.JacksonConverter {

    private final ObjectMapper myObjectMapper;

    public JacksonConverterKeepingResponse(ObjectMapper objectMapper) {
        super(objectMapper);
        this.myObjectMapper = objectMapper;
    }

    @Override
    public Object fromBody(TypedInput body, Type type) throws ResponseConversionException {
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray(body.in());

            if (bytes == null || bytes.length == 0) {
                return null;
            }

            JavaType javaType = myObjectMapper.getTypeFactory().constructType(type);
            return myObjectMapper.readValue(bytes, javaType);
        } catch (IOException e) {
            throw new ResponseConversionException(e, bytes);
        }
    }

}
