package ru.yandex.sandbox.client.retrofit;

import java.util.Optional;

import retrofit.converter.ConversionException;

/**
 * @author albazh
 */
public class ResponseConversionException extends ConversionException {

    private final Optional<byte[]> responseBytes;

    public ResponseConversionException(Throwable throwable, byte[] responseBytes) {
        super(throwable);
        this.responseBytes = Optional.ofNullable(responseBytes);
    }

    public Optional<byte[]> getResponseBytes() {
        return responseBytes;
    }
}
