package ru.yandex.sandbox.client.task;

import java.util.Collections;
import java.util.List;

import ru.yandex.sandbox.client.api.SandboxTask;
import ru.yandex.sandbox.client.api.SandboxTaskPriority;

/**
 * @author albazh
 */
public class YaCommitTaskBuilder {

    private final String type = "YA_COMMIT";

    private final String author = "robot-arcanum";
    private final String owner = "ARCANUM_COMMIT";
    private String description = "Autocommit after successful precommit check";

    private SandboxTaskPriority priority = new SandboxTaskPriority(
            SandboxTaskPriority.PriorityClass.SERVICE,
            SandboxTaskPriority.PrioritySubclass.HIGH
    );

    private String commitMessage;
    private String commitAuthor;
    private String arcadiaPatch;
    private Boolean dryRun;

    private List<String> tags = Collections.singletonList("arcanum-autocommit");

    private String svnPath;
    private String svnRevision;

    private String ciCheckId;   // this field is needed only for searching by input parameters

    public SandboxTask build() {
        SandboxTask task = new SandboxTask(null, type);
        task.setAuthor(author);
        task.setOwner(owner);
        task.setPriority(priority);
        task.setTags(tags);

        task.setDescription(description);

        task.getCustomFields().add(new YaCommitTaskParameter.ArcadiaUrl(String.format("arcadia:/arc/%s/arcadia@%s", svnPath, svnRevision)));
        task.getCustomFields().add(new YaCommitTaskParameter.CommitAuthor(commitAuthor));
        task.getCustomFields().add(new YaCommitTaskParameter.CommitMessage(commitMessage));
        task.getCustomFields().add(new YaCommitTaskParameter.Patch(arcadiaPatch));
        task.getCustomFields().add(new YaCommitTaskParameter.DryRun(dryRun));
        task.getCustomFields().add(new YaCommitTaskParameter.CiCheck(ciCheckId));

        return task;
    }

    public String getType() {
        return type;
    }

    public String getAuthor() {
        return author;
    }

    public String getOwner() {
        return owner;
    }

    public String getDescription() {
        return description;
    }

    public YaCommitTaskBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public SandboxTaskPriority getPriority() {
        return priority;
    }

    public YaCommitTaskBuilder setPriority(SandboxTaskPriority priority) {
        this.priority = priority;
        return this;
    }

    public String getCommitMessage() {
        return commitMessage;
    }

    public YaCommitTaskBuilder setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
        return this;
    }

    public String getCommitAuthor() {
        return commitAuthor;
    }

    public YaCommitTaskBuilder setCommitAuthor(String commitAuthor) {
        this.commitAuthor = commitAuthor;
        return this;
    }

    public String getArcadiaPatch() {
        return arcadiaPatch;
    }

    public YaCommitTaskBuilder setArcadiaPatch(String arcadiaPatch) {
        this.arcadiaPatch = arcadiaPatch;
        return this;
    }

    public Boolean getDryRun() {
        return dryRun;
    }

    public YaCommitTaskBuilder setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public List<String> getTags() {
        return tags;
    }

    public YaCommitTaskBuilder setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public String getSvnPath() {
        return svnPath;
    }

    public YaCommitTaskBuilder setSvnPath(String svnPath) {
        this.svnPath = svnPath;
        return this;
    }

    public String getSvnRevision() {
        return svnRevision;
    }

    public YaCommitTaskBuilder setSvnRevision(String svnRevision) {
        this.svnRevision = svnRevision;
        return this;
    }

    public String getCiCheckId() {
        return ciCheckId;
    }

    public YaCommitTaskBuilder setCiCheckId(String ciCheckId) {
        this.ciCheckId = ciCheckId;
        return this;
    }
}
