package ru.yandex.sandbox.client.task;

import java.util.HashMap;
import java.util.Map;

/**
 * @author albazh
 */
public class YaCommitTaskContext {

    private final String zipatch;
    private final String svnPath;
    private final String svnRevision;
    private final String commitMessage;
    private final String commitAuthor;
    private final boolean dryRun;

    public YaCommitTaskContext(String zipatch, String svnPath, String svnRevision,
            String commitMessage, String commitAuthor, boolean dryRun) {
        this.zipatch = zipatch;
        this.svnPath = svnPath;
        this.svnRevision = svnRevision;
        this.commitMessage = commitMessage;
        this.commitAuthor = commitAuthor;
        this.dryRun = dryRun;
    }

    public Map<String, Object> toMap() {
        Map<String, Object> result = new HashMap<>();

        result.put("arcadia_patch", zipatch);
        result.put("checkout_arcadia_from_url", String.format("arcadia:/arc/%s/arcadia@%s", svnPath, svnRevision));
        result.put("commit_message", commitMessage);
        // see https://a.yandex-team.ru/arc/trunk/arcadia/testenv/core/engine/checks.py?rev=3354892#L654
        result.put("user", commitAuthor);
        result.put("dry_run", dryRun);

        return result;
    }

    public String getZipatch() {
        return zipatch;
    }

    public String getSvnPath() {
        return svnPath;
    }

    public String getSvnRevision() {
        return svnRevision;
    }

    public String getCommitMessage() {
        return commitMessage;
    }

    public String getCommitAuthor() {
        return commitAuthor;
    }

    public boolean isDryRun() {
        return dryRun;
    }
}
