from __future__ import absolute_import

import abc
import copy


class Abstract(object):
    """
    The class is designed as simple slotted data entry storage with an ability to fill in
    slots available via keyword arguments in its constructor. In case of no value provided
    to the constructor, it will be fetched out from `__defs__` array (which should be of
    the same length as `__slots__`).

    Class stolen from `skynet.kernel.base.entity`
    """
    __slots__ = []
    __defs__ = []
    __copier__ = copy.copy

    def __init__(self, *args, **kwargs):
        for i, attr in enumerate(self.__slots__):
            _def = self.__defs__[i]
            if i < len(args):
                val = args[i]
            elif attr in kwargs:
                val = kwargs[attr]
            else:
                # noinspection PyUnresolvedReferences
                val = self.__copier__.__func__(_def)
                _def = None  # Avoid double checking
            setattr(self, attr, val if _def is None or isinstance(val, _def.__class__) else _def.__class__(val))

    def __repr__(self):
        return self.__class__.__name__ + repr(dict(self))

    def __iter__(self):
        for attr in self.__slots__:
            yield (attr, getattr(self, attr))

    def itervalues(self):
        for attr in self.__slots__:
            yield getattr(self, attr)

    def copy(self):
        return self.__class__(*(v for _, v in self))


class RWLock(object):
    __metaclass__ = abc.ABCMeta

    reader = abc.abstractproperty()
    writer = abc.abstractproperty()

    @abc.abstractmethod
    def acquire_read(self):
        pass

    @abc.abstractmethod
    def acquire_write(self):
        pass

    @abc.abstractmethod
    def release(self):
        pass
