from .. import utils


TASK_LOG_RESOURCE_TYPE = "TASK_LOGS"


class State(utils.Enum):
    """ Resource states. """

    NOT_READY = None
    READY = None
    BROKEN = None
    DELETED = None


class HostState(utils.Enum):
    """ Resource host states. """

    OK = None
    MARK_TO_DELETE = None


class LinkType(utils.Enum):
    """ Resource's data link type. """

    HTTP = None
    RSYNC = None


class ServiceAttributes(utils.Enum):
    """ Resource attributes, which are used by Sandbox itself. """

    TTL = "ttl"
    RELEASED = "released"
    BACKUP_TASK = "backup_task"


class BinaryAttributes(utils.Enum):
    """ Binary tasks' resource attributes. """

    REVISION = "commit_revision"
    BINARY_AGE = "binary_age"
    BINARY_HASH = "binary_hash"
    TASKBOX_ENABLED = "taskbox_enabled"


class RestartPolicy(utils.Enum):
    """ The enumeration defines possible actions for task's resources on task restart. """

    DELETE = None  # Delete resource
    RESET = None  # Switch resource to "NOT_READY" state
    IGNORE = None  # Do not change resource's state


def relpath(rid):
    """
    Determines resource's relative directory path name for the common data directory by given resource identifier.

    :param rid: resource ID
    :return: Array of sub-directories names.
    """
    if not rid:
        raise ValueError("{!r} is not valid resource ID".format(rid))
    rid = str(rid)
    return rid[-4:-2] or "00", rid[-2:] or "00", rid
