from .. import utils


class Status(utils.Enum):
    """ Possible scheduler statuses. """

    STOPPED = None
    WATCHING = None
    WAITING = None
    FAILURE = None
    DELETED = None


class Retry(utils.Enum):
    """ Schedulers' retry on failed tasks policies """

    # Do not retry failed tasks
    NO = "no"
    # Retry failed tasks after time interval
    INTERVAL = "interval"
    # Stop scheduler in case of failed tasks
    FAILURE = "failure"


class StartMode(utils.Enum):
    """ First scheduled task start time """

    # Start task immediately
    IMMEDIATELY = "immediately"
    # Start in scheduled time
    SET = "set"


class Repetition(utils.Enum):
    """ Scheduling policy """

    # Do not repeat
    NO = "no"
    # Run tasks periodically
    INTERVAL = "interval"
    # Run tasks in given days of week
    WEEKLY = "weekly"
