import collections

from .. import utils
from ..types import task as ctt


#: User name for anonymous login.
ANONYMOUS_LOGIN = "guest"

#: Sandbox service group.
SERVICE_GROUP = "SANDBOX"

#: Priority limits type.
PriorityLimits_t = collections.namedtuple("PriorityLimits", ("ui", "api"))

#: Virtual group name for those users, which are not any group's memeber.
OTHERS_GROUP = collections.namedtuple("OtherGroup", ("name", "priority_limits"))(
    "OTHER",
    PriorityLimits_t(
        ctt.Priority(ctt.Priority.Class.USER, ctt.Priority.Subclass.LOW),
        ctt.Priority(ctt.Priority.Class.BACKGROUND, ctt.Priority.Subclass.LOW),
    )
)

#: Maximum allowed priorities for regular users.
DEFAULT_PRIORITY_LIMITS = PriorityLimits_t(
    ctt.Priority(ctt.Priority.Class.USER, ctt.Priority.Subclass.HIGH),
    ctt.Priority(ctt.Priority.Class.SERVICE, ctt.Priority.Subclass.HIGH),
)

#: Maximum allowed priorities for superuser.
SU_PRIORITY_LIMITS = PriorityLimits_t(
    ctt.Priority(ctt.Priority.Class.USER, ctt.Priority.Subclass.HIGH),
    ctt.Priority(ctt.Priority.Class.USER, ctt.Priority.Subclass.HIGH),
)


class Restriction(utils.Enum):
    ANY = None
    AUTHENTICATED = None
    ADMIN = None
    TASK = None


class TokenSource(utils.Enum):
    """ OAuth token source enumeration. """

    PASSPORT = None
    SSH_KEY = None
    CLIENT = None


class GroupSource(utils.Enum):
    """ Source for syncing content of the group """

    STAFF = None
    RB = None
    ABC = None
    USER = None


class Rights(utils.Enum):
    """ User's rights """

    READ = "read"
    WRITE = "write"

    @classmethod
    def get(cls, write_access):
        return cls.WRITE if write_access else cls.READ


class Role(utils.Enum):
    """ User's role """

    ANONYMOUS = "anonymous"
    REGULAR = "regular"
    TRUSTED = "trusted"
    ADMINISTRATOR = "administrator"
