#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys

sys.path.insert(0, '/opt')
sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')

import logging
import bot_core as bc
import os

from yamb import Bot
from yamb.ext import Updater

logging.basicConfig(format = u'%(levelname)-8s [%(asctime)s] %(message)s', level = logging.INFO, filename = u'/var/log/yandex/direct-yamb-bot/direct-yamb-bot.log')

bot_token_file = os.environ[u'bot_token_file'] if u'bot_token_file' in os.environ else u'/etc/direct-tokens/yamb-robot-direct-notify'


def run():
    # os.environ[u'REQUESTS_CA_BUNDLE'] = u'/etc/ssl/certs/'

    bot_token = bc.get_token(bot_token_file)

    # bot = Bot(token = sys.argv[1]) сейчас выключена проверка сертификата, с выходом новых версий python 2 надо включить
    bot = Bot(token=bot_token, verify=False)

    # не обрабатываем сообщения, которые были присланы до нашего включения
    for update, error in Updater(bot).poll(interval=0.1, pulse=True):
        if update is None:
            break

    # главный цикл обработки сообщений
    for update, error in Updater(bot).poll(interval=0.1):
        if update:
            logging.info('got message')

            resp = bc.compose_response(update[u'message'])
            if resp:
                bot.send_message(
                    chat_id=update[u'message'][u'chat'][u'id'],
                    text=resp,
                )

                logging.info('message sent')
            else:
                logging.warning('empty message to send')

        elif error:
            logging.error(u'Error occured: %s' % error)


if __name__ == '__main__':
    run()

