#!/usr/bin/fab -f 
# -*- coding:utf-8 -*-
"""
Удаленное выполнение команд на dupload.dist.yandex.ru от имени спец-пользователя robot-direct-dmover-keys

для выполнения настоящих действий нужно sudo, dry run можно и без него

    Пробный запуск:
    DRY_RUN=1 direct-dist.py dmove_stable:yandex-direct,1.82616-1

    Запускать можно и сам по себе, и через fab:
    fab -f direct-dist.py --list
    direct-dist.py --list
    
    Список всех команд:
    direct-dist.py --list

    Короткая справка:
    direct-dist.py help

    Справка по отдельной команде:
    direct-dist.py -d find_package

    Перемещение пакетов (dmove):
    direct-dist.py dmove_stable:dp,yandex-direct,1.82616-1              # перемещение из testing
    direct-dist.py dmove_prestable_stable:dp,yandex-direct,1.82616-1
    direct-dist.py dmove:dp,unstable,testing,yandex-direct,1.82616-1
    direct-dist.py dmove:repo=dp,src=unstable,dst=testing,package=yandex-direct,version=1.82616-1

    Массовое перемещение пакетов (dmove):
    direct-dist.py dmove_from_file:dp,unstable,testing,filename
    direct-dist.py dmove_from_file:dp,unstable,testing,-
    direct-dist.py dmove_testing_from_file:dp,filename
    direct-dist.py dmove_stable_from_file:dp,-                          # перемещение из testing
    direct-dist.py dmove_prestable_stable_from_file:dp,-

    Удаление пакетов (rmove)
    direct-dist.py rmove:dmp,unstable,direct-moderate,1.11423.11493-1

    Копирование пакетов из другого репозитория
    direct-dist.py bmove:dt,dmp,unstable,yandex-du-ts-updater,1.60-1

    Поиск пакетов:
    direct-dist.py find_package:yandex-direct_1.80838~ssl-ciphers-web-nginx-1

    TODO
    + rmove
    + массовый dmove
    - когда понадобится -- массовый rmove аналогично массовому dmove
    - научиться безопасно развозить ключи по всем нужны машинам (ppcdev*)

"""

import sys, re, os

from fabric.api import *


env.hosts = ['dupload.dist.yandex.ru']
env.user = 'robot-direct-dmover'
env.key_filename = '/etc/robot-direct-dmover-keys/id_rsa'
env.disable_known_hosts = True

allowed_repos = ["direct-mod-precise", "direct-precise", "direct-trusty", "direct-xenial", "direct-common"]

aliases = {
        "dc": "direct-common",
        "dp": "direct-precise",
        "dt": "direct-trusty",
        "dx": "direct-xenial",
        "dmp": "direct-mod-precise",
        }


def my_run(*args,**kwargs):
    if os.getenv('DRY_RUN', '') == "1":
        print "dry run: %s" % (args[0])
    else: 
        run(args[0])

def normalize_repo(repo):
    if repo in aliases:
        return aliases[repo]
    else: 
        return repo

@task
def help():
    """
    help
    """
    print(__doc__)


def _mass_dmove(repo, src, dst, to_dmove):
    """
    переместить много пакетов между репозиториями (unstable/testing/unstable)
    """
    norm_repo = normalize_repo(repo)
    if not norm_repo in allowed_repos:
        print "repo %s isn't allowed, stop" % (repo)
        exit(57)

    i = 0
    for task in to_dmove:
        i += 1
        if len(task) != 2:
            print "task #%s: wrong format '%s', stop" % (i, task)
            exit(57)

        if not re.match( r'^[a-z0-9-.]+$', task[0],):
            print "task #%s: incorrect package name '%s', stop\n" % (i, task[0])
            exit(57)

        if not re.match( r'^[a-z0-9-.~:]+$', task[1], re.I):
            print "task #%s: incorrect version '%s', stop\n" % (i, task[1])
            exit(57)

    for task in to_dmove:
        my_run("sudo dmove %s %s %s %s %s" % (norm_repo, dst, task[0], task[1], src))


@task
def dmove_from_file(repo, src, dst, filename):
    """
    переместить много пакетов между репозиториями (unstable/testing/unstable)
    пакеты и версии читаются из файла, по одному на строку: yandex-direct[ ,=_]1.23456-1
    если вместо имени файла '-' (дефис) -- читается stdin
    """
    if filename == "-": 
         fd = sys.stdin
    else: 
         fd = open(filename, 'r')

    # зачитываем весь файл, парсим, ничего не валидируем; валидация -- в _mass_dmove
    to_dmove = []
    for line in fd:
        line = line.rstrip()
        if re.match( r'^#', line):
            continue
        if re.match( r'^\s*$', line):
            continue

        parts = re.split("[ ,=_]", line)

        to_dmove += [ parts ]

    _mass_dmove(repo, src, dst, to_dmove)


@task
def dmove(repo, src, dst, package, version):
    """
    переместить пакет между репозиториями (unstable/testing/unstable)
    """
    _mass_dmove(repo, src, dst, [ [package, version] ])


@task
def dmove_testing(repo, package, version):
    """
    переместить пакет из unstable в testing
    """
    dmove(repo, "unstable", "testing", package, version)


@task
def dmove_prestable(repo, package, version):
    """
    переместить пакет из unstable в prestable
    """
    dmove(repo, "unstable", "prestable", package, version)


@task
def dmove_stable(repo, package, version):
    """
    переместить пакет из testing в stable
    """
    dmove(repo, "testing", "stable", package, version)


@task
def dmove_prestable_stable(repo, package, version):
    """
    переместить пакет из prestable в stable
    """
    dmove(repo, "prestable", "stable", package, version)


@task
def dmove_testing_from_file(repo, filename):
    """
    переместить много пакетов из unstable в testing; список пакетов берется из файла; "-" -- stdin
    """
    dmove_from_file(repo, "unstable", "testing", filename)


@task
def dmove_prestable_from_file(repo, filename):
    """
    переместить много пакетов из unstable в prestable; список пакетов берется из файла; "-" -- stdin
    """
    dmove_from_file(repo, "unstable", "prestable", filename)


@task
def dmove_stable_from_file(repo, filename):
    """
    переместить много пакетов из testing в stable; список пакетов берется из файла; "-" -- stdin
    """
    dmove_from_file(repo, "testing", "stable", filename)


@task
def dmove_prestable_stable_from_file(repo, filename):
    """
    переместить много пакетов из prestable в stable; список пакетов берется из файла; "-" -- stdin
    """
    dmove_from_file(repo, "prestable", "stable", filename)


@task
def find_package(pattern):
    """
    поиск пакета на dupload.dist.yandex.ru
    """
    my_run('find_package.sh %s' % (pattern))


#rmove <branch> <repo> <package> <version>
@task
def rmove(repo, src, package, version):
    """
    удалить пакет
    """
    norm_repo = normalize_repo(repo)
    if not norm_repo in allowed_repos:
        print "repo %s isn't allowed, stop" % (repo)
        exit(1)
    my_run("sudo rmove %s %s %s %s" % (norm_repo, src, package, version))


# bmove <-c|-m> <branch> <torepo> <package> <version> <fromrepo>
@task
def bmove(src, dst, branch, package, version):
    """
    скопировать пакет в репозиторий
    """
    fromrepo = normalize_repo(src)
    torepo = normalize_repo(dst)
    if not torepo in allowed_repos:
        sys.exit("copying to repo %s is not allowed, stop" % (torepo))
    # у робота есть пишущий доступ ко всем репозиториям на dist'е, поэтому разрешено только копирование (-c), но не перемещение (-m), чтобы не удалить случайно пакет из "чужого" репозитория
    # для того, чтобы после копирования удалить пакет из "нашего" репозитория-источника, есть rmove
    my_run("sudo bmove -c %s %s %s %s %s" % (branch, torepo, package, version, fromrepo))

if __name__ == '__main__':
        
    print """Usage: 
fab -f direct-dist.py <command>:parameters
or
direct-dist.py <command>:parameters

list of available commands:
direct-dist.py --list
"""

