#!/usr/bin/perl

$deb_file = $ARGV[0];
die "Usage: $0 deb_file (deb_file_1.0_all.deb)\n" if not $deb_file;

$info = qx(dpkg -I $deb_file);
%data = map { (/^ (\w+): (\S+.*)$/) ? ($1, $2) : () } split /\n/s, $info;
($data{size}) = ($info =~ m/size (\d+) bytes/);
($data{date} = qx(date '+%a, %d %b %Y %H:%M:%S %z')) =~ s/\n$//s;
($data{sha1} = qx(sha1sum $deb_file)) =~ s/\s.*\n$//s;
($data{sha256} = qx(sha256sum $deb_file)) =~ s/\s.*\n$//s;
($data{md5} = qx(md5sum $deb_file)) =~ s/\s.*\n$//s;
$data{Section} //= "misc";
$data{Priority} //= "optional";

($changes_file = $deb_file) =~ s/\.deb$/.changes/;
open($file, '>', $changes_file);


print $file <<EOF;
Format: 1.8
Date: $data{date}
Source: $data{Package}
Binary: $data{Package}
Architecture: $data{Architecture}
Version: $data{Version}
Distribution: unstable
Maintainer: $data{Maintainer}
Changed-By: $ENV{DEBFULLNAME} <$ENV{DEBEMAIL}>
Urgency: low
Description:
 $data{Description}
Changes:
 $data{Package} ($data{Version}) unstable; urgency=low
 .
   * Auto generated changes file for $data{Package}
Checksums-Sha1:
 $data{sha1} $data{size} $deb_file
Checksums-Sha256:
 $data{sha256} $data{size} $deb_file
Files:
 $data{md5} $data{size} $data{Section} $data{Priority} $deb_file
EOF
close($file);

system(qq(debsign -m\$DEBEMAIL $changes_file));

