#!/usr/bin/perl
use strict;
use warnings;
use Cwd;

my %data;
my @multibinary;
my @multisha1;
my @multisha256;
my @multifiles;
my @description;
my $changes_file;

sub get_dpkg_info {
    (my $deb_file) = @_;
    my $info = qx(dpkg -I $deb_file);
    %data = map { (/^(?:##)? ?(\w+): (\S+.*)$/) ? ($1, $2) : () } split /\n/s, $info;
    ($data{size}) = ($info =~ m/size (\d+) bytes/);
    ($data{date} = qx(date '+%a, %d %b %Y %H:%M:%S %z')) =~ s/\n$//s;
    ($data{sha1} = qx(sha1sum $deb_file)) =~ s/\s.*\n$//s;
    ($data{sha256} = qx(sha256sum $deb_file)) =~ s/\s.*\n$//s;
    ($data{md5} = qx(md5sum $deb_file)) =~ s/\s.*\n$//s;
    ($data{file}) = ($deb_file =~ m|.*/(.*)$|);
    ($data{Description}) =~ s/\n.*//s;
    $data{Source} //= $data{Package};
    $data{Section} //= "misc";
    $data{Priority} //= "optional";
}

sub multi_package {
    my $directory = getcwd();
    print "$directory\n";
    opendir (DIR, $directory) or die $!;
    while ( my $file = readdir(DIR)) {
        next unless (-f "$file");
        next unless ( $file =~ m/\.deb$/ );
        print "$file";
        get_dpkg_info( $file );
        push @multibinary, $data{Package};
        push @multisha1, " $data{sha1} $data{size} $file";
        push @multisha256, " $data{sha256} $data{size} $file";
        push @multifiles, " $data{md5} $data{size} $data{Section} $data{Priority} $file";
        $file =~ s/_.*\.deb$//;
        push @description, " $file - $data{Description}";
        print " - OK\n";
    };
    $data{Package} = join " ", sort @multibinary;
    $data{sha1} = join "\n", @multisha1;
    $data{sha256} = join "\n", @multisha256;
    $data{files} = join "\n", sort @multifiles;
    $data{Description} = join "\n", sort @description;
    $changes_file = ( $data{Source}."_".$data{Version}."_".$data{Architecture}.".changes");       
    closedir(DIR);
}

sub single_package {
    my $deb_file = $ARGV[0];
    get_dpkg_info( $deb_file );
    $data{sha1} += (join ' ',$data{size},$ARGV[0]);
    $data{sha256} += (join ' ',$data{size},$ARGV[0]);
    $data{files} += (join ' ',$data{md5},$data{size},$data{Section},$data{Priority},$deb_file,"\n");
    ($changes_file = $deb_file) =~ s/\.deb$/.changes/;       
}

my @deb_files = @ARGV;
die "Usage: $0 deb_file (deb_file_1.0_all.deb); or $0 multi in directory with deb files\n" if not @deb_files;
if ( index ($ARGV[0], "multi" ) != -1) {
	multi_package();
} else {
	single_package();
}

open( my $changesfile, '>', $changes_file);

print $changesfile <<EOF;
Format: 1.8
Date: $data{date}
Source: $data{Source}
Binary: $data{Package}
Architecture: $data{Architecture}
Version: $data{Version}
Distribution: trusty 
Maintainer: $data{Maintainer}
Changed-By: $ENV{DEBFULLNAME} <$ENV{DEBEMAIL}>
Urgency: low
Description:
$data{Description}
Changes:
 $data{Package} ($data{Version}) unstable; urgency=low
 .
   * Auto generated changes file for $data{Package}
Checksums-Sha1:
$data{sha1}
Checksums-Sha256:
$data{sha256}
Files:
$data{files}
EOF
close($changesfile);

system(qq(debsign -m\$DEBEMAIL $changes_file));
