#!/usr/bin/perl

=for none

    Тест проверяетш валидацию входных данных для dmove-а

=cut

use strict;
use warnings;

use Test::More;

use FindBin qw/$Bin/;



my %tasks = (
    good => [
"yandex-direct 1.111-1",
"yandex-direct 1.111-1 ",
"yandex-direct 1.111-1
",
"yandex-direct 1.111-1
# a b c d
",
"
# a b c d
yandex-direct 1.111-1
# a b c d
",
"yandex-direct a ",
"
yandex-direct 1.222-1
yandex-direct 1.222-1
",
"
yandex-direct 1.222-1
yandex-direct=1.222-1
",
"
yandex-direct 1.222-1
yandex-direct,1.222-1
",
"
yandex-direct 1.222-1
yandex-direct_1.222-1
",
    ],

    empty => [
"
# a b c d
",
"
",
"",
"
# abcdef ghij
### yandex-direct 1.222-1
"
    ],

    bad => [
"yandex-direct 1.111-1 1.222-1",
" yandex-direct 1.222-1",
"yandex-direct   ",
" yandex-direct   ",
"yandex-direct ;rm",
"
yandex-direct 1.222-1
yandex-direct 
",
"
yandex-direct 1.222-1
yandex-direct:1.222-1
",
"
yandex-direct 1.222-1
yandex-direct 1.222-1 1.333-1
",
"
yandex-direct 1.222-1 1.333-1
yandex-direct 1.222-1
",
"
yandex-direct 1.222-1 1.333-1
yandex-direct 
",
"
yandex-direct 1.222-1
yandex-direct 1.222-1 1.333-1
yandex-direct 1.222-1
",
"
yandex-direct 1.222-1 1.333-1
yandex-direct 1.222-1
yandex-direct 1.222-1 1.333-1
",

        {
            name => "",
            tasks => 
            "yandex-direct 1.111-1 1.222-1
            ",
        },
    ],
);

=head2 execute_cmd

    выполняет переданную команду, проверяет статус завершения и вывод в соответствии с типом: 
    good -- хорошая команда, завершается успехом, удаленные команды выполняются;
    bad  -- ошибочная команда, завершается неуспехом, удаленные команды не выполняются;
    empty -- хорошая но "пустая" команда: завершается успехом, удаленные команды не выполняются;
    ''   -- никаких проверок не делается.

    Возвращает вывод выполненной команды

=cut
sub execute_cmd
{
    my ($cmd, $type, $name) = @_;

    my $output = qx($cmd);
    my $status = $? >> 8;

    if ($type eq "good"){
        is($status, 0, "good task '$name', exit code.");
        ok($output =~ /dry run:/, "good task '$name', something executed")
    } elsif ( $type eq "empty" ){
        is($status, 0, "empty task '$name', exit code");
        ok($output !~ /dry run:/, "good task '$name', nothing executed")
    } elsif ($type eq 'bad') {
        is($status, 57, "bad task '$name', exit code");
        ok($output !~ /dry run:/, "bad task '$name', nothing executed")
    } elsif ( $type eq '' ){
        # nothing, just return the output
    } else {
        die "unexpected type '$type'";
    }
    return $output;
}

for my $type (qw/empty good bad/){
    my $i;
    for my $testcase ( @{$tasks{$type}} ){
        $i++;
        my ($tasks, $name);
        if (ref $testcase eq "HASH"){
            $tasks = $testcase->{tasks};
            $name = $testcase->{name} || "test case # $i";
        } else {
            $tasks = $testcase;
            $name = "test case # $i";
        }
        my ($cmd, $output);

        $cmd = qq(cat <<EOF |DRY_RUN=1 $Bin/../../bin/dt-dist dmove_from_file -r dp -f unstable -t testing - 2>&1
$tasks
EOF);
        $output = execute_cmd($cmd, $type, $name);
        if ($type eq "good"){
            # короткие имена репозоториев -- с минусами
            ok($output !~ /(?<!-)\bdp\b/, "short repository name");
        }

        $cmd = qq(cat <<EOF |DRY_RUN=1 $Bin/../../bin/dt-dist dmove_from_file -r direct-precise -f unstable -t testing - 2>&1
$tasks
EOF);
        $output = execute_cmd($cmd, $type, $name);
        if ($type eq "good"){
            # длинные имена репозоториев -- без минусов
            ok($output !~ /(?<=-)\bdirect-precise\b/, "full repository name");
        }
        
        # неразрешенные репозитории -- нельзя
        $cmd = qq(cat <<EOF |DRY_RUN=1 $Bin/../../bin/dt-dist dmove_from_file -r unallowed-repo -f unstable -t testing - 2>&1
$tasks
EOF);
        execute_cmd($cmd, "bad", $name);
    }
}


done_testing();

