#!/bin/sh -e

version="${1:?expecting a version as first argument}"

mkdir build
cd build
mkdir bin
curl -L "https://github.com/docker/compose/releases/download/$version/docker-compose-`uname -s`-`uname -m`" -o bin/docker-compose
chmod +x bin/docker-compose

cat <<EOF > meta.yaml
---
package: direct-docker-compose
description: Docker Compose for Direct
EOF

cat <<EOF > changes
$version
 * очередная сборка
EOF

debosh --dirty

echo ""
echo "SUCCESS!"
echo "Result files here: build/debian"
echo "to upload to dist: dupload build/debian"
echo "to clean up: rm -rf build"
