#!/usr/bin/perl

=head1 NAME

    create-branch.pl

=head1 SYNOPSIS

    create-branch.pl -b my-cool-branch-name -j DIRECT-12345 --switch

=head1 DESCRIPTION

    Создаёт бранч под задачу и записывает название бранча в тикет

=cut

use strict;
use warnings;
use utf8;

use Getopt::Long;
use Pod::Usage;

use Startrek::Client::Easy ();
use Yandex::Shell ();
use ProjectSpecific ();

my ($HELP, $BRANCH, $TICKET, $SWITCH);
GetOptions(
    'help|?' => \$HELP,
    'branch=s' => \$BRANCH,
    'j|ticket=s' => \$TICKET,
    'switch' => \$SWITCH,
) or pod2usage(2);
pod2usage(1) if $HELP || !$BRANCH || !$TICKET;

my $startrek = Startrek::Client::Easy->new();

print STDERR "Fetching ticket title for $TICKET...\n";
my $issue = $startrek->get(key => $TICKET);
die "Error fetching $TICKET data" unless $issue && $issue->{key} && $issue->{summary};
die "Branch $issue->{branch} is already specified for $issue->{key}" if $issue->{branch};

print STDERR "Creating branch $BRANCH...\n";
my $trunk_svn_url = ProjectSpecific::svn_url('trunk');
my $branch_svn_url = ProjectSpecific::svn_url(branch => $BRANCH);
my $commit_message = "$BRANCH:\n- бранч для задачи $issue->{key}: $issue->{summary}";
Yandex::Shell::yash_system(qw(svn cp -m), $commit_message, $trunk_svn_url, $branch_svn_url);

print "Updating branch in ticket $issue->{key}...\n";
$startrek->do(key => $issue->{key}, branch => $BRANCH);

if ($SWITCH) {
    print "Switching current directory to newly created branch...\n";
    Yandex::Shell::yash_system(qw(svn switch), $branch_svn_url);
}

print "DONE: $branch_svn_url\n";
