#!/bin/sh -e 

# Предысторию см. https://wiki.yandex-team.ru/direct/development/howto/direct-chrome/

# ВАЖНО! Скрипт рассчитан на сознательного и внимательного пользователя. 
# Внимательно смотри за параметрами и не запускай, если не понимаешь, что делаешь. 

# Пользоваться так: 
# 1. Скачать нужный хром
# wget 'https://storage.googleapis.com/chromium-browser-snapshots/Linux_x64/551292/chrome-linux.zip'
# 2. Запустить скрипт, параметрами передать путь к chrome-linux.zip и ревизию (из нее образуется версия)
# В текущем каталоге образуется chrome-build, а в нем debian, и там -- собранные пакеты
# 3. Загрузить пакеты на dist
# chrome-build/debian/
# Удалить ненужное
# rm -rf chrome-build chrome-linux.zip

if [ -z "$1" -o ! -f "$1" ] 
then
    echo "expecting .zip file"
    exit 1
fi

if [ -z "$2" ]
then
    echo "expecting a revision"
    exit 1
fi

mkdir chrome-build
mkdir chrome-build/opt -p
unzip $1 -d chrome-build/opt

cat <<EOF > chrome-build/meta.yaml
---
package: direct-headless-chrome
description: headless chrome for Direct
EOF


cat <<EOF > chrome-build/changes
1.$2
 * очередная сборка
EOF

cd chrome-build 

debosh --dirty

echo ""
echo "SUCCESS!"
echo "Result files here: chrome-build/debian"
echo "to upload to dist: dupload chrome-build/debian"
