# -* encoding: utf-8 -*-
import json
import string
import urllib
import urllib2

JUGGLER_API_URL = 'http://dimon.yandex.net:8998/api'
USER_AGENT = 'Direct.JugglerMonitoring'

JUGGLER_CE_NICE_TEXT_RULES = {
    'description': [
        # graphite_threshold объединяет описания через |
        ('|', "\n"),
        # типовой путь в графите почти всегда содержит эти строки
        ('direct_one_min.db_configurations.production.', '_.'),
        ('one_min.direct.production.', '_.'),
    ],
    'summary': [
        (' from ', '/'),
    ],
}

PARAMS_TRANSLATION = {
    'hosts': 'host_name',
    'tags': 'tag_name',
    'status': 'status',
    'service_name': 'service_name',
}


def _process_filter_params(all_params, filters=[]):
    """
    из словаря all_params делает список туплов 
    ( ('host_name', '...'), ('host_name', '...'), ('service_name', '...') )
    включает только параметры, указанные в filters
    """
    good_params = list()

    for filter_param in filters:
        if filter_param not in PARAMS_TRANSLATION:
            raise Exception('no param translation for {0}'.format(filter_param))

        if filter_param in all_params and type(all_params[filter_param]) is list and len(all_params[filter_param]):
            good_params.extend(map(lambda p: (PARAMS_TRANSLATION[filter_param], p), all_params[filter_param]))

    if not good_params:
        raise ValueError('There are no applicable conditions for filtering')

    return good_params


def get_data_from_juggler_api(*args, **kwargs):
    if 'type' not in kwargs:
        raise Exception('missing data type')
    else:
        pass

    params = [('do', '1')]  # выполнить запрос, а не получить документацию

    if kwargs['type'] == 'raw_events':
        method = 'events/raw_events'
        params.extend(_process_filter_params(kwargs, ['hosts', 'status', 'service_name']))

        if 'without_obsolete' in kwargs and kwargs['without_obsolete']:
            # включая события с истекшим TTL
            params.append(('without_obsolete_flag', '1'))

    elif kwargs['type'] == 'complete_events':
        method = 'events/complete_events'
        params.extend(_process_filter_params(kwargs, ['hosts', 'tags', 'status', 'service_name']))

        if 'with_no_methods' in kwargs and kwargs['with_no_methods']:
            # включая события без методов
            params.append(('all_flag', '1'))

    elif kwargs['type'] == 'downtimes':
        method = 'downtimes/downtimes'

        if 'service' in kwargs and kwargs['service']:
            params.append(('service_name', kwargs['service']))

        if 'object' in kwargs and kwargs['object']:
            params.append(('object_name', kwargs['object']))

        if 'expand_groups' in kwargs and kwargs['expand_groups']:
            params.append(('expand_flag', '1'))

    elif kwargs['type'] == 'suggest_event_host':
        method = 'dashboard/suggest_checks'
        query = 'h@%s?' % kwargs.get('host', '')
        params.append(('query', query))

    elif kwargs['type'] == 'checks':
        method = 'checks/checks'

    else:
        raise Exception('unknown data type')

    # Для использования старого Juggler'а группируем параметры по ключу
    if 'old_juggler_format' in kwargs and kwargs['old_juggler_format']:
        params_by_key = dict()
        for kv_pair in params:
            try:
                params_by_key[kv_pair[0]].add(kv_pair[1])
            except KeyError:
                params_by_key[kv_pair[0]] = set([kv_pair[1]])
        params = list((k, string.join(map(str, list(v)), ',')) for k, v in params_by_key.items())

    req = urllib2.Request('{0}/{1}?{2}'.format(JUGGLER_API_URL, method, urllib.urlencode(params)))
    req.add_header('User-agent', USER_AGENT)
    return json.loads(urllib2.urlopen(req).read())


def nice_text(text, field=None):
    new_text = text
    if field in JUGGLER_CE_NICE_TEXT_RULES:
        for old, new in JUGGLER_CE_NICE_TEXT_RULES[field]:
            new_text = new_text.replace(old, new)
    return new_text
