# -*- coding: utf8 -*-

from app import app, render_template, request
from models import CompleteEvents, RawEvents
from tools import get_data_from_juggler_api
import json
import os
import sys
from collections import defaultdict

HOSTS_FILE = os.environ.get('HOST_FILE', '/direct-juggler-viewer/app/hosts.json')
hosts = json.loads(open(HOSTS_FILE, 'r').read())
host_tags = {}
"""
делаем такое:
    {
    'direct' : {
        'api.direct.yandex.ru': {
            'direct-admin': True,
            'important': True
        }, 
        'direct.db.ppcdata': {
            'important': True
        },
    }
    }
"""
for project in hosts:
    if project not in host_tags:
        host_tags[project] = {}
    for h in hosts[project]:
        if h['host'] not in host_tags[project]:
            host_tags[project][h['host']] = defaultdict(str)
        for t in h['tags']:
            host_tags[project][h['host']][t] = True

"""
делаем такое:
	{
		'direct.yandex.ru': 'direct',
		'bm.db.smth': 'bm',
	}
"""
host_to_project_dict = {}
for project in hosts:
	for h in hosts[project]:
		host_to_project_dict[h['host']] = project


def host_to_project(host):
    if host in host_to_project_dict:
        return host_to_project_dict[host]
    else:
        return '-'


@app.route('/')
@app.route('/index')
def index():
    return render_template('index.html',
            )


@app.route('/ce/')
@app.route('/ce/<path:params>')
def complete_events(params=''):
    form = {
            'project': request.args.get('project', ''),
            'host': request.args.get('host', ''),
            'service': request.args.get('service', ''),
            'host_tag': request.args.get('host_tag', ''),
            'include_status': {
                'CRIT': request.args.get('include_CRIT', False),
                'WARN': request.args.get('include_WARN', False),
                'OK': request.args.get('include_OK', False),
                },

            }
    error_message = ''

    if not form['project'] and not form['host'] and not form['service']:
        return render_template('complete_events.html',
                form=form,
                error_message=u'Пустые параметры поиска, показать нечего'
                )

    hosts_to_search = []
    service_to_search = []
    if form['project']:
        hosts_to_search = [h['host'] for h in hosts[form['project']]]
        # TODO выфакторизовать в функцию
        if form['host_tag']:
            hosts_to_search = [ h for h in hosts_to_search if host_tags[form['project']][h][form['host_tag']] ]
    elif form['host']:
        hosts_to_search = [form['host']]
    elif form['service']:
        service_to_search = [form['service']]
    else:
        pass

    try:
        statuses = [st for st in form['include_status'] if form['include_status'][st]]
        events = CompleteEvents(hosts=hosts_to_search, service_name=service_to_search, status=statuses)
        events.sort()
        events.filter_list_by_params(host=form['host'], service=form['service'])
    except:
        events = CompleteEvents([], from_list=[])
        error_message = "Error getting events: %s" % [ str(i) for i in sys.exc_info()]


    return render_template('complete_events.html',
            form=form,
            error_message = error_message,
            events=events.get(),
            )


@app.route('/re/')
@app.route('/re/<path:params>')
def raw_events(params=''):
    form = {
            'host': request.args.get('host', ''),
            'service': request.args.get('service', ''),
            'include_status': {
                'CRIT': request.args.get('include_CRIT', False),
                'WARN': request.args.get('include_WARN', False),
                'OK': request.args.get('include_OK', False),
                },
            }
    error_message = ''

    if not form['host'] and not form['service']:
        return render_template('raw_events.html',
                form=form,
                error_message=u'Пустые параметры поиска, показать нечего'
                )

    hosts_to_search = []
    service_to_search = []
    if form['host']:
        hosts_to_search = [form['host']]
    if form['service']:
        service_to_search = [form['service']]

    try:
        statuses = [st for st in form['include_status'] if form['include_status'][st]]
        events = RawEvents(hosts=hosts_to_search, service_name=service_to_search, status=statuses )
        events.sort()
    except:
        events = RawEvents([])
        error_message = "Error getting events: %s" % [ str(i) for i in sys.exc_info()]

    return render_template('raw_events.html',
            form=form,
            error_message = error_message,
            events=events.get(),
            )


@app.route('/checks/')
@app.route('/checks/<path:params>')
def checks(params=''):
    form = {
            'project': request.args.get('project', ''),
            'host_tag': request.args.get('host_tag', ''),
            'host': request.args.get('host', ''),
            'service': request.args.get('service', ''),
            'show_status': request.args.get('show_status', ''),
            'include_status': {
                'CRIT': request.args.get('include_CRIT', False),
                'WARN': request.args.get('include_WARN', False),
                'OK': request.args.get('include_OK', False),
                },
            }
    error_message = ''

    if False:
        return render_template('checks.html',
                form=form,
                error_message=u''
                )

    all_checks = get_data_from_juggler_api(type='checks',)
    checks = []
    for host in all_checks.keys():
        project = host_to_project(host)
        if form['project'] and project != form['project']:
            continue
        if form['host'] and host != form['host']:
            continue
        for service in all_checks[host].keys():
            if form['service'] and service != form['service']:
                continue
            check = {
                    'project': project,
                    'host': host,
                    'service': service,
                    'static_props': {},
                    }
            for k in [ 'methods', 'tags', ]:
                check[k] = all_checks[host][service][k] or []
            checks.append(check)
            #check['_orig'] = all_checks[host][service]

    return render_template('checks.html',
            form=form,
            checks=checks,
            error_message=u''
            )


@app.route('/dt/')
@app.route('/dt/<path:params>')
def downtimes(params=''):
    form = {
            'host': request.args.get('host', ''),
            'service': request.args.get('service', ''),
            }
    error_message = ''

    if False:
        return render_template('raw_events.html',
                form=form,
                error_message=u'Пустые параметры поиска, показать нечего'
                )

    return render_template('downtimes.html',
            form=form,
            error_message = error_message,
            )
