#!/usr/bin/env python
# -*- encoding: utf-8 -*-

import os
import sys
import subprocess
import yaml

if len(sys.argv) < 3:
    print('Use %s app ticket(e.g. DIRECT-123456)' % sys.argv[0])
    sys.exit(0)

apps_conf_file = os.environ['APPS_CONF'] if 'APPS_CONF' in os.environ else '/etc/yandex-direct/direct-apps.conf.yaml'

app = sys.argv[1]
ticket = sys.argv[2]


def init_apps_conf():
    global apps_conf
    with open(apps_conf_file) as fh:
        apps_conf = yaml.load(fh)
    return

def run_ext(cmd):
   print("going to exec: %s\n" % cmd)
   try:
       res = subprocess.check_output(cmd).rstrip()
   except:
       print("cmd failed, stop (%s)" % cmd)
       res = ''
   return res

init_apps_conf()
task = run_ext(['get-release-sandbox-task', ticket])

if task == '':
    print("Can't get sandbox task, exit.")
    sys.exit(1)

run_ext(['/usr/local/bin/dt-sandbox-resource-release.py', '-s', 'stable', '-t', task])

stage = apps_conf['apps'][app]['yadeploy-stages']['production']
print('Deploy to ' + stage)
deploy_message =  'релиз %s: %s' % (app, ticket)
run_ext(['dt-update-yadeploy-stage', '--stage', stage, '--sandbox-task', task, '--commit', '-m', deploy_message ])
