#!/usr/bin/python
# -*- coding: utf8 -*-

import os
import sys
import argparse

sys.path.insert(0, 'opt/release_changelog')
sys.path.insert(0, '/opt/release_changelog')
import changelog_utils

"""
Фильтрует svn log и оставляет только те коммиты, в которых затронуты зависимости приложения.
"""

if os.environ.get('SSH_MASTER_CONN_ARCADIA', ''):
    os.environ["SVN_SSH"] = "ssh -S %s" % os.environ['SSH_MASTER_CONN_ARCADIA']


def main():
    parser = argparse.ArgumentParser(description='Get svn logs related to the specific app from arcadia')
    parser.add_argument('app', type=str, choices=changelog_utils.APPS_CONFIG.keys(), help='app name')
    parser.add_argument('l_rev', type=int, help='first revision in range')
    parser.add_argument('r_rev', type=int, help='last revision in range')
    parser.add_argument('--working-copy', type=str, help='path to working copy')
    args = parser.parse_args()

    svnlog = changelog_utils.get_svnlog_with_deps(args.app, args.l_rev, args.r_rev, working_copy=args.working_copy)
    print changelog_utils.prettify_log(svnlog)

if __name__ == '__main__':
    main()
