#!/usr/bin/perl

=head1 DESCRIPTION

(Временный) скрипт для проверки данных в chassis.deploy

Получаем выкладки парсингом комментариев:
./bin/dt-check-trunk-to-prod-data.pl |grep '^2020' |grep -vw dna |sort |uniq > deploys.tracker

Получаем выкладки из БД:
m dt:chassis 'select date(deploy_time), ticket_key, app, version from deploy where deploy_time >= "2020-01-01"' -B |sed -e 's/\t/ /g' |tail -n +2 |sort > deploys.db

Смотрим, чего не хватает/что лишнее:
diff -u deploys.tracker deploys.db

Загрузить на paste:
curl -s -X POST 'https://paste.yandex-team.ru' -d "syntax=plain" --data-urlencode text@<(diff -u deploys.tracker deploys.db) -i | awk '/Location:/ { print $2 }'

=cut

use strict;
use warnings;

use feature qw/state/;

use Getopt::Long;
use YAML;
use DateTime::Format::Strptime;
use Data::Dumper;

use ProjectSpecific qw/svn_url/;

use Startrek::Client::Easy;

use utf8;
use open ':std' => ':utf8';

# Startrek::Client::Easy returns only ids of components
our %COMPONENTS = (
    31053 => 'App: java_api5',
    30820 => 'App: java_intapi',
    31819 => 'App: java_jobs',
    30439 => 'App: java_logviewer',
    34789 => 'App: java_web',
    41082 => 'App: java_user_action_log_writer',
    43064 => 'App: java_binlog_to_yt_sync',
    45572 => 'App: java_binlog_recommendations_tracer',
    46886 => 'App: db_schema',
    53505 => 'App: canvas',
    53425 => 'App: ess_router',
    49723 => 'App: binlogbroker',
    38919 => 'App: dna',
    60208 => 'App: mysql2yt_full',
    72226 => 'App: oneshot',
    9574  => 'Releases: Direct',
);

our $ARCADIA_URL = 'svn+ssh://arcadia.yandex.ru/arc';
our $apps_conf;
our %component2app;

run() unless caller();

sub run
{
my $st = tracker_object();
    $apps_conf = YAML::LoadFile("/etc/yandex-direct/direct-apps.conf.yaml");
    for my $app (keys $apps_conf->{apps}) {
        if (exists $apps_conf->{apps}->{$app}->{'tracker-component'}) {
            $component2app{$apps_conf->{apps}->{$app}->{'tracker-component'}} = $app;
        }
    }
    my $time_parser = new DateTime::Format::Strptime(pattern => "%Y-%m-%dT%H:%M:%S");

    my @releases;
    for my $p (1 .. 100){
        my $releases = $st->get(query => q!Queue: DIRECT Type: Release Updated: >= 2020-01-01!, page => $p, perPage => 100); 
        last unless scalar @$releases; 
        push @releases, @$releases;
    }

    my @deploys;
    for my $issue (@releases){
        my $app = issue2app($issue);
        
        my $last_id = 0;
        my (@comments, $comments_chunk);
        for (1 .. 20) {
            if ($last_id) {
                $comments_chunk = $st->request('GET', "/issues/$issue->{key}/comments?id=$last_id&perPage=100");
            } else {
                $comments_chunk = $st->request('GET', "/issues/$issue->{key}/comments?perPage=100");
            }
            last unless @$comments_chunk;
            $last_id = $comments_chunk->[- 1]->{id};
            push @comments, @$comments_chunk;
        }

        for my $c ( @comments ){
            my $text = $c->{text};
            if ( $text =~ m/Пакет версии ([^ ]*) установлен на группе продакшеновых машин/ ){
                my $version = $1;
                my $dt = $time_parser->parse_datetime($c->{createdAt});
                $dt->add( hours => 3);
                my $d = {
                    issue => $issue->{key},
                    app => $app,
                    version => $version,
                    date => $dt->strftime("%Y-%m-%d"),
                };
                push @deploys, $d;
            }
        }
    }

    for my $d ( @deploys ){
        print join (" ", map { $d->{$_} } qw/date issue app version/);
        print "\n";
    }
}


sub issue2app
{
    my $issue = shift;
    for my $comp (@{$issue->{components}}) {
        if (exists $COMPONENTS{$comp} && exists $component2app{$COMPONENTS{$comp}}) {
            return $component2app{$COMPONENTS{$comp}};
        }
    }
    return "UNKNOWN_APP";
}


sub tracker_object
{
    state $tracker;
    $tracker //= Startrek::Client::Easy->new();
    return $tracker;
}

