#!/usr/bin/python
# -*- coding: utf8 -*-

"""
m pr:chassis 'select date(c.time), app, delay_type, delay_seconds, delay_wo_weekend_seconds, delay_wo_weekend_and_night_seconds from commit_timings ct join commit c on c.revision = ct.commit_revision order by commit_revision asc' -B |tail -n +2 > commit_timings.dates
"""

import sys
import datetime

def percentile(arr, P):
    s = len(arr) - 1
    if s == 0:
        return 0
    N = int(round(s*P/100.00))
    return arr[N]


def run():
    # 2020-01-01      binlogbroker    Rft     1784354 1265954 617954
    STAT = {}
    prev_day_str = ""
    for line in sys.stdin.readlines():
        day_str, app, delay_type, delay1, delay2, delay3 = line.rstrip().split('\t')
        if day_str != prev_day_str:
            prev_day_str = day_str
        day = datetime.datetime.strptime(day_str, '%Y-%m-%d')

        if app not in STAT:
            STAT[app] = {}
        if delay_type not in STAT[app]:
            STAT[app][delay_type] = {}
        for d in ['delay1', 'delay2', 'delay3']:
            if d not in STAT[app][delay_type]:
                STAT[app][delay_type][d] = {}

        for delta in range(0, 28):
            window_day = day + datetime.timedelta(days=delta)
            window_day_str = window_day.strftime('%Y-%m-%d')
            for d in ['delay1', 'delay2', 'delay3']:
                if window_day_str not in STAT[app][delay_type][d]:
                    STAT[app][delay_type][d][window_day_str] = []
            STAT[app][delay_type]['delay1'][window_day_str].append(delay1)
            STAT[app][delay_type]['delay2'][window_day_str].append(delay2)
            STAT[app][delay_type]['delay3'][window_day_str].append(delay3)


    for app in sorted(STAT.keys()):
        proc = 80
        values = []
        for delay_type in sorted(STAT[app].keys()):
            for d in ['delay1', 'delay2', 'delay3']:
                if d != 'delay2':
                    continue
                for window_day_str in sorted(STAT[app][delay_type][d]):
                    p = percentile(STAT[app][delay_type][d][window_day_str], proc)
                    values.append( "(%s)" % ",".join([str(a) for a in ["'%s'" % window_day_str, "'%s'" % app, 28, proc, "'%s'" % delay_type, p]]))

        sql = """insert into commit_timings_percentiles
        (day, app, window, percentile, delay_type, delay_seconds)
        values
        %s;
        """ % ",\n".join(values);
        print sql


    return

if __name__ == '__main__':
    run();

