#!/usr/bin/env python
# -*- coding: utf8 -*-

description = """
"""

import os
import re
import sys

sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')
from startrek_client import Startrek

import argparse
import json
import yaml
import requests
import urllib


SCRIPT_NAME = os.path.basename(__file__)

STARTREK_TOKEN_FILE = '/etc/direct-tokens/startrek'

with open(STARTREK_TOKEN_FILE) as st_fd:
    startrek_token = st_fd.readline().strip()
startrek_client = Startrek(token=startrek_token, useragent=SCRIPT_NAME)

APPS_CONF_FILE = "/etc/yandex-direct/direct-apps.conf.yaml"
with open(APPS_CONF_FILE) as apps_fd:
    APPS_CONF = yaml.load(apps_fd)['apps']

CHAT = {
        'java-web': -1001266366506,
        'java-jobs': -1001309346329,
        'java-intapi': -1001302852689,
        'java-api5': -1001275616636,
        'oneshot': -1001200122445,
        'java-logviewer': -1001265515507,
        'canvas': -1001423636713,
        }


def calculate_chat_title(app):
    to_send = {"title": "...", "message": ""}

    release_component = APPS_CONF[app]['tracker-component']
    st_query = 'Queue: DIRECT Type: Release Components: "%s" "Sort By": created DESC' % release_component
    releases = startrek_client.issues.find(st_query, per_page=1)
    release = next(iter(releases))

    to_send['title'] = u'..::%s::.. %s' % (release.status.key, app)
    to_send['message'] = u"статус %s\n%s\n%s" % (release.status.key, release.key, release.summary)

    return to_send


def get_current_title(app):
    url = 'http://ppcdev4.yandex.ru:5000/get_chat_info'
    params = {
            'bot': 'yd_herald',
            'chat_id': CHAT[app],
            }
    r = requests.get(url, params=params, verify=False, timeout=20)
    r.raise_for_status()
    data = r.json()

    return data['chat_info']['title']


def set_title_with_message(app, to_send):
    url_title = 'http://ppcdev4.yandex.ru:5000/set_title'
    params_title = {
            'bot': 'yd_herald',
            'chat_id': CHAT[app],
            'title': to_send['title'],
            }
    r = requests.get(url_title, params=params_title, verify=False, timeout=20)
    r.raise_for_status()

    url_message = 'http://ppcdev4.yandex.ru:5000/send_message'
    params_message = {
            'bot': 'yd_herald',
            'chat_id': CHAT[app],
            'message': to_send['message'],
            }
    r = requests.get(url_message, params=params_message, verify=False, timeout=20)
    r.raise_for_status()

    return



def parse_options():
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument("-a", "--app", dest="app", help="приложение", type=str)
    parser.add_argument("-h", "--help", dest="help", help="Справка", action="store_true")
    opts, extra = parser.parse_known_args()

    if opts.help:
        print description
        print parser.format_help()
        exit(0)

    if not opts.app:
        exit("-a <app> expected")

    opts.extra = extra

    return opts


def run():
    opts = parse_options()

    to_send = calculate_chat_title(opts.app)

    current_title = get_current_title(opts.app)
    if(to_send['title'] != current_title):
        set_title_with_message(opts.app, to_send)

    exit(0)


if __name__ == '__main__':
    run();
