#!/usr/bin/python
# -*- encoding: utf-8 -*-

description = """
Переводит релизный тикет в из статуса New в Ready For Test
"""

import sys
import os

sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')
from startrek_client import Startrek

import re
import argparse
import subprocess

STARTREK_TOKEN_FILE = '~/.startrek_client_token'
SCRIPT_NAME = os.path.basename(__file__)


def parse_options():
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument("-h", "--help", dest="help", help="Справка", action="store_true")
    parser.add_argument("-t", "--ticket", dest="ticket", help="Релизный тикет", type=str)
    opts, extra = parser.parse_known_args()

    if opts.help:
        print description
        print parser.format_help()
        exit(0)

    opts.extra = extra

    if len(extra) > 0:
        exit("unexpected params %s" % extra)

    if not opts.ticket:
        sys.exit("ticket expected, stop")

    return opts


def run():
    opts = parse_options()

    startrek_token = open(os.path.expanduser(STARTREK_TOKEN_FILE)).readline().strip()
    startrek_client = Startrek(token=startrek_token, useragent=SCRIPT_NAME)

    issue = startrek_client.issues[opts.ticket]
    if issue.status.key != 'new':
        sys.exit("expecting ticket in status 'new', found '%s'" % issue.status.key)

    issue.transitions['ready_for_test'].execute(comment=u"Ready for test, скрипт dt-release-rft.py")

    return


if __name__ == '__main__':
    run()

