#!/usr/bin/python
# -*- encoding: utf-8 -*-

description = """
Делает release на сандбоксовой таске
dt-sandbox-resource-release.py -t 750370752 -s stable
"""

import sys
import os

sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')
from startrek_client import Startrek

import argparse
import json
import re
import requests
import subprocess

SCRIPT_NAME = os.path.basename(__file__)


def parse_options():
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument("-h", "--help", dest="help", help="Справка", action="store_true")
    parser.add_argument("-t", "--task", dest="task_id", help="id таска в Сандбоксе", type=int)
    parser.add_argument("-s", "--subject", dest="release_subject", help="subject (testing|stable)", type=str)
    opts, extra = parser.parse_known_args()

    if opts.help:
        print description
        print parser.format_help()
        exit(0)

    opts.extra = extra

    if len(extra) > 0:
        exit("unexpected params %s" % extra)

    if not opts.task_id:
        sys.exit("task expected, stop")

    if not opts.release_subject:
        sys.exit("subject expected, stop")

    return opts


def run():
    opts = parse_options()

    SANDBOX_TOKEN_FILE = os.environ.get("SANDBOX_TOKEN_FILE", os.environ['HOME'] + '/.sandbox/token')
    sandbox_token = open(os.path.expanduser(SANDBOX_TOKEN_FILE)).readline().strip()

    sandbox_release_params = {
            'subject': opts.release_subject,
             'task_id': opts.task_id,
             'type': opts.release_subject,
            }

    resp = requests.post(
            'https://sandbox.yandex-team.ru/api/v1.0/release',
            data=json.dumps(sandbox_release_params),
            headers={
                'Authorization': 'OAuth ' + sandbox_token,
                'Content-Type': 'application/json'
                })
    resp.raise_for_status()

    return


if __name__ == '__main__':
    run()

