#!/usr/bin/python
# -*- encoding: utf-8 -*-

description = """
Переводит тикет в новый статус и/или пишет комментарий

Посмотреть возможные переходы по статусам:
dt-tracker-change-status-comment.py -t DIRECT-131617

Поменять статус:
dt-tracker-change-status-comment.py -t DIRECT-131617 -r stop_progress

Поменять статус и написать комментарий:
dt-tracker-change-status-comment.py -t DIRECT-131617 -r stop_progress -c 'Стоп'

Написать комментарий:
dt-tracker-change-status-comment.py -t DIRECT-131617 -c 'some text'
"""

import sys
import os

sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')
from startrek_client import Startrek

import re
import argparse
import subprocess
import logging

logging.getLogger("startrek_client.collections").addHandler(logging.NullHandler())

STARTREK_TOKEN_FILE = '~/.startrek_client_token'
SCRIPT_NAME = os.path.basename(__file__)


def parse_options():
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument("-h", "--help", dest="help", help="Справка", action="store_true")
    parser.add_argument("-t", "--ticket", dest="ticket", help="Тикет", type=str)
    parser.add_argument("-r", "--transition", dest="transition", help="Переход по статусам", type=str)
    parser.add_argument("-c", "--comment", dest="comment", help="Комментарий", type=str)
    opts, extra = parser.parse_known_args()

    if opts.help:
        print description
        print parser.format_help()
        exit(0)

    opts.extra = extra

    if len(extra) > 0:
        exit("unexpected params %s" % extra)

    if not opts.ticket:
        sys.exit("ticket expected, stop")

    return opts


def run():
    opts = parse_options()

    startrek_token = open(os.path.expanduser(STARTREK_TOKEN_FILE)).readline().strip()
    startrek_client = Startrek(token=startrek_token, useragent=SCRIPT_NAME)

    issue = startrek_client.issues[opts.ticket]

    possible_transitions = [t.id for t in issue.transitions.get_all()]

    if not opts.transition and not opts.comment:
        print "Possible transitions (%s):\n" % len(possible_transitions) + "\n".join([(" * %s" % t) for t in possible_transitions])
    elif opts.transition:
        if opts.transition not in possible_transitions:
            sys.exit("transition '%s' not possible for ticket %s (possible: %s)" % ( opts.transition, opts.ticket, ", ".join(possible_transitions) ))
        if opts.comment:
            issue.transitions[opts.transition].execute(comment=opts.comment)
        else:
            issue.transitions[opts.transition].execute()
    elif opts.comment:
        issue.comments.create(text=opts.comment)
    else:
        sys.exit("something went terribly wrong")

    return


if __name__ == '__main__':
    run()

