#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import sys

sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')

import requests
import yaml
from startrek_client import Startrek, exceptions


APPS_CONF_FILE = "/etc/yandex-direct/direct-apps.conf.yaml"
APPS_CONFIG = None
SCRIPT_NAME = os.path.basename(__file__)
STARTREK_TOKEN_FILE = '~/.startrek_client_token'

startrek_client = None


def find_releases_in_statuses(app, statuses):
    global APPS_CONFIG
    global startrek_token
    global startrek_client
    component = APPS_CONFIG[app]['tracker-component']
    statuses_str = ", ".join( [ '"%s"' % s for s in statuses] )
    ST_QUERY = u'Queue: DIRECT Type: Release Components: "%s" Status: %s' % (component, statuses_str)
    tickets = startrek_client.issues.find(ST_QUERY)
    return tickets

def get_linked_issues(app, release_issue):
    global APPS_CONFIG
    links_tested = {}
    affected_apps_tag =  APPS_CONFIG[app]['tracker-affected-app']
    release_testing_tag = 'release_testing_%s' % app

    for l in release_issue.links.get_all():
        link = l.object
        try:
            if affected_apps_tag not in link.affectedApps:
                continue
        except exceptions.Forbidden:
            print(link.key)
            continue

        if affected_apps_tag not in link.testedApps and release_testing_tag in link.tags:
            person = link.qaEngineer or link.assignee or link.createdBy
            links_tested.setdefault(person.login, []).append(link.key)

    return links_tested

def get_telegram_login(staff_logins):
    global startrek_token
    api = "https://staff-api.yandex-team.ru/v3"
    r = requests.get("%s/persons?_fields=login,accounts&login=%s" % (api,','.join(staff_logins)), headers={'Authorization': 'OAuth %s' % startrek_token})

    result = {}
    for row in r.json()['result']:
        telegram_contacts = [a for a in row['accounts'] if a['type'] == 'telegram']
        result[row['login']] = '@' + telegram_contacts[0]['value'] if telegram_contacts else row['login'] + '@'

    for login in staff_logins:
        if login not in result:
            result[login] = login + '@'

    return result

def send_telegram_message(message, test=False):
    if not message:
        return

    test_chat_id = '-520589734' # https://t.me/joinchat/1KndC4Aqn7ZjNjUy тестовый чат
    release_chat_id = '-1001072994247' # чат direct-release
    if test:
        chat_id = test_chat_id
    else:
        chat_id = release_chat_id

    message_limit = 4000

    chunks = []
    cur_message = []
    for line in message.split('\n'):
        if len(cur_message) + len(line) > message_limit:
            chunks.append('\n'.join(cur_message))
            cur_message = []
        else:
            cur_message.append(line)
    if cur_message:
        chunks.append('\n'.join(cur_message))

    for chunk in chunks:
        url = 'http://sparkle-deploy.yandex.net/plugin-telegram-bot?quiet'
        if not test:
            url += '&markdown'
        print '============ message chunk =============='
        print chunk.encode('utf-8')
        print requests.post(url, json={ 'message': chunk, 'chat-id': chat_id }).text


def make_st_filter(keys):
    # Key:+DIRECT-123123+or+KEY:+DIRECT-99999
    query = '+or+'.join(['Key:+%s' % k for k in keys])
    return 'https://st.yandex-team.ru/issues/?_q=%s&_f=type+priority+key+summary+status+updated+author+assignee+sprint' % query

def prepare_message(app, release, links, telegram_logins, test=False):
    result = u''

    if test:
        result += u'Контрольное сообщение\n\n'

    use_markdown = not test

    if use_markdown:
        escape_login = lambda x: x.replace('_', '\_')
        staff_link = lambda x: '[%s](https://staff.yandex-team.ru/%s)' % (escape_login(x), x)
        st_link = lambda x: '[%s](https://st.yandex-team.ru/%s)' % (x, x)
    else:
        identity = lambda x: x
        escape_login = identity
        staff_link = identity
        st_link = identity

    result += u'Релиз %s %s ожидает тестирования тикетов:\n\n' % ('**%s**' % app if use_markdown else app, st_link(release.key))

    for login, tickets in links.items():
        telegram_login = escape_login(telegram_logins[login])
        staff = staff_link(login)
        tickets_suffix = ', '.join([st_link(t) for t in tickets])
        filter_suffix = u'[фильтр в трекере](%s)' % make_st_filter(tickets)

        line = '%s (staff %s): %s(%s)\n' % (telegram_login, staff, tickets_suffix, filter_suffix)

        result += line

    if result:
        result += '\n========================\n\n\n'
    return result


def run():
    global APPS_CONFIG
    global startrek_token
    global startrek_client
    with open(APPS_CONF_FILE) as apps_fd:
        APPS_CONFIG = yaml.load(apps_fd)['apps']

    startrek_token = open(os.path.expanduser(STARTREK_TOKEN_FILE)).readline().strip()

    startrek_client = Startrek(token=startrek_token, useragent=SCRIPT_NAME)

    message = u''
    control_message = u''

    for app in APPS_CONFIG.keys():
        print app
        releases = find_releases_in_statuses(app, ['Ready For Test', 'Testing'])
        for release in releases:
            print release.key
            links = get_linked_issues(app, release)
            if not links:
                continue
            telegram_logins = get_telegram_login(links.keys())

            message += prepare_message(app, release, links, telegram_logins, test=False)
            control_message += prepare_message(app, release, links, telegram_logins, test=True)
        print '================'

    send_telegram_message(message, test=False)
    # send_telegram_message(control_message, test=True)


if __name__ == '__main__':
    run()
