#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')

import json
import os
import re
import requests

def run():
    script_name = os.path.basename(sys.argv[0])
    usage_msg = '''
  Usage: {0} <sandbox-task-id>
  Example: {0} 1234567890
'''.format(sys.argv[0])
    if len(sys.argv) != 2:
        sys.exit("{0}: incorrect number of arguments\n".format(script_name) + usage_msg)
    if not re.match(r'^[0-9]+$', sys.argv[1]):
        sys.exit("{0}: sandbox task id expected to be integer but was '{1}'".format(script_name, sys.argv[1]))
    task_id = sys.argv[1]

    resp = requests.get('https://sandbox.yandex-team.ru/api/v1.0/task/' + task_id)
    resp.raise_for_status()
    task_info = json.loads(resp.text)
    task_status = task_info['status']
    if task_info['status'] in ('EXCEPTION', 'STOPPED'):
        sys.stderr.write("{0}: task {1} ended with status {2}, no test results available\n".format(script_name, task_id, task_status))
        sys.exit(3)
    elif task_info['status'] not in ('SUCCESS', 'FAILURE'):
        sys.stderr.write("{0}: task {1} is still running\n".format(script_name, task_id))
        sys.exit(2)

    resp = requests.get('https://sandbox.yandex-team.ru/api/v1.0/resource', params={'limit': 1, 'type': 'TEST_ENVIRONMENT_JSON_V2', 'task_id': task_id})
    resp.raise_for_status()
    results_url = json.loads(resp.text)['items'][0]['http']['proxy']

    resp = requests.get(results_url)
    resp.raise_for_status()
    results = json.loads(resp.text)

    failed_tests = []
    for item in results['results']:
        if item['type'] in ('test', 'style') and item['status'] == 'FAILED' and not item.get('suite', False):
            failed_tests.append({
                'name': item['name'],
                'error_type': item['error_type'],
                'path': item['path'],
                'log': item.get('links', {}).get('log', None),
            })

    print json.dumps(failed_tests, indent=4, sort_keys=True)

if __name__ == '__main__':
    run()
