#!/bin/sh

# если есть мастер-соединениие (созданное в direct-release), то используем его
get_master_conn_param() {
    env_name="SSH_MASTER_CONN_$(echo "$1" | tr a-z.- A-Z__)"
    [[ -n "${!env_name}" ]] && echo "-S ${!env_name}" || echo ""
}

usage="$0 (8080|8999|9090|9091|9900) [<direct-svn-up.pl argument>]

8080, 8999 - Direct
9900 - Directmod"

if [ "$1" = "-h" ]; then
    echo "Usage: $usage"
    exit 0
fi

if [ -z "$1" ]; then
    echo "no beta number specified"
    echo "Usage: $usage"
    exit 1
fi
beta_num=$1
beta_path=
beta_host=
direct_svn_up_arg=
action="up"

if [ "$beta_num" = "8080" ]; then
    direct_svn_up_arg=${2:-"startrek:before-last"}
    beta_host=ppcdev1.da.yandex.ru
    beta_path="/var/www/beta.ppc.$beta_num"
elif [ "$beta_num" = "8999" ]; then
    direct_svn_up_arg=${2:-"startrek:last"}
    beta_host=ppcdev1.da.yandex.ru
    beta_path="/var/www/beta.ppc.$beta_num"
elif [ "$beta_num" = "9090" ]; then
    direct_svn_up_arg=${2:-"startrek:before-last"}
    beta_host=ppcdev2.yandex.ru
    beta_path="/var/www/beta.ppc.$beta_num"
elif [ "$beta_num" = "9091" ]; then
    direct_svn_up_arg=${2:-"startrek:last"}
    beta_host=ppcdev2.yandex.ru
    beta_path="/var/www/beta.ppc.$beta_num"
elif [ "$beta_num" = "9900" ]; then
    direct_svn_up_arg=${2:-"startrek:before-last"}
    beta_host=ppcmoddev2.yandex.ru
    beta_path="/var/www/mod.mod.$beta_num"
elif [ "$beta_num" = "9910" ]; then
    direct_svn_up_arg=${2:-"startrek:last"}
    beta_host=ppcmoddev2.yandex.ru
    beta_path="/var/www/mod.mod.$beta_num"
    action="up_9910"
else
    echo "incorrect beta number, should be 8080, 8999 or 9900,9910 for directmod"
    echo "Usage: $usage"
    exit 1 
fi

if [ "$RELEASE_BETA_UP_DIRECT_USE_UPDATER" != 1 ] && expr "$beta_host" : ppcdev > /dev/null; then
    ssh $(get_master_conn_param "$beta_host") "$beta_host" sudo /usr/local/bin/ts-update.pl --conf=/etc/ts-updater/direct.conf --conf=/etc/ts-updater/dmove-testing.conf --conf=/etc/ts-updater/dmove-prestable.conf direct-mk "$beta_path" "$action" "$direct_svn_up_arg"
else
    ssh $(get_master_conn_param "$beta_host") updater@"$beta_host" direct-mk "$beta_path" "$action" "$direct_svn_up_arg"
fi
