#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')

import json
import os
import requests
import yaml

def run():
    script_name = os.path.basename(sys.argv[0])
    usage_msg = '''
  Usage: {0} <app> <revision>
  Example: {0} java-intapi 1234567
'''.format(sys.argv[0])
    if len(sys.argv) != 3:
        sys.exit("{0}: incorrect number of arguments\n".format(script_name) + usage_msg)
    app = sys.argv[1]
    rev = int(sys.argv[2])
    with open('/etc/yandex-direct/direct-apps.conf.yaml', 'r') as f:
        apps_config = yaml.load(f)['apps']
    if app not in apps_config:
        sys.exit("{0}: unknown app '{1}'".format(script_name, app))
    app_type = apps_config[app]['type']
    if app_type != 'arcadia-java':
        sys.exit("{0}: expected app with type 'arcadia-java', but '{1}' has type '{2}'".format(script_name, app, app_type))
    svn_dir = apps_config[app]['primary-svn-dir']

    arcadia_url = 'arcadia:/arc/trunk/arcadia@' + str(rev)
    ya_make_task_params = {
        'checkout_arcadia_from_url': arcadia_url,
        'use_aapi_fuse': True,
        'use_arc_instead_of_aapi': True,
        'checkout': False,
        'keep_on': True,
        'test': True,
        'allure_report': False,
        'targets': ';'.join([svn_dir, 'direct/common', 'direct/core', 'direct/libs', 'direct/libs-internal'])
    }
    sandbox_task_params = {
        'type': 'YA_MAKE_2',
        'priority': ['SERVICE', 'NORMAL'],
        'owner': 'DIRECT',
        'description': u'Запуск юнит-тестов для приложения {0}, ревизия {1}'.format(app, rev),
        'notifications': [],
        'custom_fields': [{'name': name, 'value': ya_make_task_params[name]} for name in ya_make_task_params.keys()],
        'requirements': { 'platform': 'linux_ubuntu_14.04_trusty', 'disk_space': 20 * 1024 * 1024 * 1024 }, # аналогично sandbox-ya-package
    }

    with open(os.environ['HOME'] + '/.sandbox/token') as f:
        sandbox_token = f.read().rstrip()
    resp = requests.post('https://sandbox.yandex-team.ru/api/v1.0/task', data=json.dumps(sandbox_task_params), headers={'Authorization': 'OAuth ' + sandbox_token, 'Content-Type': 'application/json'})
    resp.raise_for_status()
    task_id = json.loads(resp.text)['id']
    resp = requests.put('https://sandbox.yandex-team.ru/api/v1.0/batch/tasks/start', data=json.dumps({'id': [int(task_id)]}), headers={'Authorization': 'OAuth ' + sandbox_token, 'Content-Type': 'application/json'})
    resp.raise_for_status()
    print task_id

if __name__ == '__main__':
    run()
