#!/usr/bin/env bash
# Обновляет переводы для указанной релизной SVN-ветки директа
# нужен, чтобы обновлять переводы в релизных ветках
# параметр -- название релизной ветки
# пользоваться так:
# ./upd-release-i18n release-xxxxxx

set -e

RELEASE_BRANCH="$1"
export TANKER_BRANCH="master"

RELEASES_URL="svn+ssh://arcadia.yandex.ru/arc/branches/direct/release/perl"

TMP_PATH="/tmp/temp-ttl/ttl_7d"

# утилиты из data3
TANKER="node_modules/tanker-kit/bin/tanker"

THIS_SCRIPT=$(basename "$0")


if [[ -z "$RELEASE_BRANCH" ]]
then
    echo "[$THIS_SCRIPT] Передайте название релизной ветки в качестве аргумента";
    exit 1;
fi

echo "[$THIS_SCRIPT] Создание временной папки в $TMP_PATH"
TMP_DIR=$(mktemp -d "$TMP_PATH"/"$THIS_SCRIPT".XXXXXX)

if [[ ! -d "$TMP_DIR" ]]
then
    echo "[$THIS_SCRIPT] Не удалось создать временную папку в $TMP_PATH";
    exit 1;
fi

echo "[$THIS_SCRIPT] Загрузка ветки $RELEASES_URL/$RELEASE_BRANCH"
svn checkout "$RELEASES_URL/$RELEASE_BRANCH" "$TMP_DIR"
cd "$TMP_DIR"

if [[ ! -d "data3" ]]
then
    echo "[$THIS_SCRIPT] Папка data3 не найдена";
    exit 1;
fi

echo "[$THIS_SCRIPT] Установка зависимостей"
cd "data3"
# устанавливаем все модули, чтобы не зависеть от списка тех, которые нужны для обновления `bricks.translations`
npm i

if [[ ! -f "$TANKER" ]]
then
    echo "[$THIS_SCRIPT] Утилита tanker-kit не установлена";
    exit 1;
fi

echo "[$THIS_SCRIPT] Обновление файлов переводов"
# tanker push -d -- чтобы сгенерировать правильный map.json,
"$TANKER" push -d > unusedTankerData.json
"$TANKER" pull

# раньше была зависимость от скрипта `data3/utils/add-i18n.sh`,
# но стал делать `exit 1` при добавлении файлов переводов
# поэтому явно смотрим на модификации
I18N_FILES=$(svn st | grep ^? | grep .i18n | xargs -n1 | grep -v ?)

if [ -n "$I18N_FILES" ]
then
    echo "$I18N_FILES" | xargs svn add
    echo "[$THIS_SCRIPT] OK";
else
    echo "[$THIS_SCRIPT] Добавить нечего";
fi

if [[ -n "$(svn st | grep .i18n | grep ^[AM])" ]] # Если в svn есть добавленные/изменённые файлы i18n
then
    echo "[$THIS_SCRIPT] Коммит обновлённых переводов в репозиторий $RELEASES_URL/$RELEASE_BRANCH";
    svn commit -m "RELEASE: Обновление переводов для data3"
else
    echo "[$THIS_SCRIPT] Файлы переводов не изменились";
fi

exit 0
