package DirectRelease::Description;

use strict;
use warnings;

use utf8;

use open qw/:std :encoding(UTF-8)/;

use base qw/Exporter/;

our @EXPORT_OK = qw(logs2description description2logs);

# из changelog и migration собирает description для тикета
# передаем сюда migration_tickets_all (миграции с прошлого раза) и need_create_migration_tickets (флаг "будут созданы новые миграции")
sub logs2description
{
    my %options = @_;

    # составляем описание релиза: берем changelog...
    my $description = qq!====<# <a name="changelog">Изменения</a> #>==\n<{Expand\n$options{changelog}\n}>!;

    # ...и если есть migration-инструкции -- дописываем их сверху
    my @migration_parts;
    # если были готовые тикеты
    push @migration_parts, join "", map {"$_\n"} @{$options{migration_tickets_all}||[]};
    push @migration_parts, "__MIGRATIONS_PLACEHOLDER__\n" if $options{need_create_migration_tickets};

    my $migration_text = join '', @migration_parts;

    $migration_text =~ s/[\n]{3,}/\n\n/g;
    if ( $migration_text ) {
        $description = qq!\n==<# <span style="color:orange;">Инструкция к выкладке </span> #>==\n{{anchor name='migration'}}\n$migration_text\n----\n$description!;
    }
    $description = "$description\n---\n----\n!!(grey)Заголовок и описание тикета сгенерированы автоматически и используются в скриптах, не нужно их изменять вручную!!!";
    return $description;
}


# разбирает description в хеш {changelog => ...,}
sub description2logs
{
    my $description = shift;

    my $h = {};
    (my $migration_text, $h->{changelog}) = $description =~ m!^(?:[\n]*[^\n]*\n+[^\n]*name='migration'[^\n]*\n(.*)----\n)?===[^\n]*name="changelog"[^\n]*==\n(?:<{[^\n]*\n)?(.*?)(?:}>)?\s*(?:\n-{3}.*\!\!\!)?\s*$!s;

    return $h;
}

1;
