package DirectRelease::Migrations;

use strict;
use warnings;

use utf8;

use open qw/:std :encoding(UTF-8)/;

use base qw/Exporter/;

our @EXPORT_OK = qw(what_to_do_migrations migration_details find_migration_ticket);

use DirectRelease::Description qw(description2logs logs2description);
use Startrek::Client::Easy;
use Text::Diff;
use Text::Diff::Parser;
# use через eval, т.к. Module::Info на mysql-ной грамматике работает очень долго и тормозит сборку пакетов
# как посмотреть, как работает парсинг: perl -MO=Module::Info,modules_used bin/java-release.pl
eval "use MigratorB::Parse";

our $ARCADIA_URL = 'svn+ssh://arcadia.yandex.ru/arc';
our $VERSION_RE = '1\.([0-9]{7,})(?:\.([0-9]{7,}))?-[0-9]+';

our $st = Startrek::Client::Easy->new();

sub what_to_do_migrations
{
    my $migration_details = shift;
    my $app_full_name = shift;
    
    my $to_do_struct = {migrations => []};
    # to_do на миграции
    # 1. Создаем
    for my $migr_file ( sort keys %{$migration_details->{migration_files}||{}} ){
        my $migr_params = {
            create => 1,
            type => 'task',
            description => "%%\n$migration_details->{migration_files}->{$migr_file}\n%%",
            summary => "$app_full_name: Миграция $migr_file",
            queue => "DIRECTMIGR",
        };
        push @{$to_do_struct->{migrations}}, $migr_params;
    }
    # 2. Обновляем
    for my $migr_ticket ( sort keys %{$migration_details->{migration_tickets_to_update}||{}} ){
        #print "migr_ticket $migr_ticket\n$migration_details->{migration_tickets_to_update}->{$migr_ticket}\n\n";
        my $migr_params = {
            key => $migr_ticket,
            description => "%%\n$migration_details->{migration_tickets_to_update}->{$migr_ticket}\n%%",
        };
        push @{$to_do_struct->{migrations}}, $migr_params;
    }
    
    return $to_do_struct;
}


sub migration_details
{
    my %O = @_;

    my $version = $O{version};
    my $ticket = $O{ticket};
    my $app_full_name = $O{app_full_name};
    my $r = $O{release_issue};

    die "expecting 'app_full_name' parameter" unless $app_full_name;

    die unless $r;

    my ($base_rev, $head_rev) = $version =~ /^$VERSION_RE$/;
    $head_rev //= $base_rev;

    my $is_hotfix = ($head_rev != $base_rev);
    die "no release to hotfix to\n" if $is_hotfix && !$ticket;

    my ($old_version, $old_base_rev, $old_head_rev, $exists_release_branch);
    my ($rev1, $rev2, $path);
    ($old_version, $old_base_rev, $old_head_rev) = $r->{summary} =~ /\b($VERSION_RE)\b/;
    die "could not get version from string '$r->{summary}'\n" unless $old_version;
    $old_head_rev //= $old_base_rev;
    $exists_release_branch = $ticket && ($old_head_rev != $old_base_rev);

    my $svn_app_deploy_path;
    my $svn_common_deploy_path;

    if ($ticket) {
        my $changelog = description2logs($r->{description})->{changelog};
        if ($changelog) {
            ($rev1) = $changelog =~ m/^.*?r(\d+)/sm;
        } else {
            # первый релиз
            my $svn_log_cmd = "svn log -r 1:HEAD --limit 1 $ARCADIA_URL/trunk/arcadia/".YAML::LoadFile("/etc/yandex-direct/direct-apps.conf.yaml")->{apps}->{"$app_full_name"}->{"primary-svn-dir"};
            ($rev1) = `$svn_log_cmd` =~ /^r([0-9]+)/m;
        }
        if (!defined $rev1) {
            die "can't determine base revision for release";
        }
    } else {
        $rev1 = $old_base_rev // 0;
        $rev1 += 1;
    }
    $rev2 = $head_rev;

    if (! $is_hotfix && ! $exists_release_branch) {
        $svn_app_deploy_path = "$ARCADIA_URL/trunk/arcadia/".YAML::LoadFile("/etc/yandex-direct/direct-apps.conf.yaml")->{apps}->{"$app_full_name"}->{"primary-svn-dir"}."/deploy";
        $svn_common_deploy_path = "$ARCADIA_URL/trunk/arcadia/direct/deploy";
    } elsif ($is_hotfix) {
        $svn_app_deploy_path = "$ARCADIA_URL/branches/direct/release/$app_full_name/$base_rev/arcadia/".YAML::LoadFile("/etc/yandex-direct/direct-apps.conf.yaml")->{apps}->{"$app_full_name"}->{"primary-svn-dir"}."/deploy";
        $svn_common_deploy_path = "$ARCADIA_URL/branches/direct/release/$app_full_name/$base_rev/arcadia/direct/deploy";
    } elsif(! $is_hotfix && $exists_release_branch ){
        die "can't slide when release branch exists\n";
    } else {
        die "can't be"
    }

    # filterdiff используем на случай, если в deploy у файлов менялись svn-properties: Text::Diff::Parser не умеет такое разбирать
    my @log;
    for my $svn_path ($svn_app_deploy_path, $svn_common_deploy_path) {
        my @log_new = qx!svn diff --depth=files --no-diff-deleted -r $rev1:$rev2 $svn_path |filterdiff --clean!;
        if (@log_new) {
            push @log, @log_new;
        }
    }
    my $raw_log_text = join '', @log;
    my $diff_parser = Text::Diff::Parser->new( Diff=>$raw_log_text );

    my $warning = '';
    my %modified;

    my $M;
    for my $svn_path ($svn_app_deploy_path, $svn_common_deploy_path) {
        my $output = qx!svn diff -r $rev1:$rev2 --summarize $svn_path | "grep" '^M' --color=never!;
        if ($output) {
            $M .= "\n$output";
        }
    }

    if ($M) {
        # модифицирована (не добавлена, а именно модифицирована) migration-запись
        $warning = "ВНИМАНИЕ!!!\nМодифицирована migration-запись, необходима проверка:\n$M\n";
        %modified = map { s!.*\s.*/(\S+)!$1!; $_ => 1} grep {$_} split /\n/, $M;
    }

    my $files = {};
    foreach my $change ( $diff_parser->changes ) {
        my $filename = $change->filename2;
        $filename =~ s!^($svn_app_deploy_path|$svn_common_deploy_path)/!!;
        # Соглашение: файлы *.data не включаем в список
        next if $filename =~ m/\.data$/;
        # бывают файлы *.csv (по смыслу те же *.data), их тоже пропускаем
        next if $filename =~ m/\.csv$/;
        # shell-ных миграций не бывает, но разрешаем скрипты складывать в /deploy как данные (инструкция по запуску будет в отдельном .migr)
        next if $filename =~ m/\.sh$/;
        # такой файл может быть в пустой директории, чтобы она чекаутилась в hg
        next if $filename eq '.placeholder';
        # разрешаем .md файлы для описания содержимого директории
        next if $filename =~ m/\.md$/;
        # модифицированные (не добавленные, а отредактированные) файлы пропускем
        next if $modified{$filename};

        my $size = $change->size;
        my @lines = map { $change->text( $_ ) } 0..($size-1);

        my $text=join "\n", @lines;
        # YAML::Load не работает, если текст не заканчивается переводом строки
        $text .= "\n" unless $text =~ /\n$/;
        $files->{ $filename } = MigratorB::Parse::to_text($filename => $text);
    }

    # миграции, что уже созданы тикетами (захотфиксились, например), записываем в отдельный список
    my $migr_tickets_all = [];
    my $migr_tickets_to_update = {};
    for my $migr_file ( sort keys %$files ){
        my $ticket = find_migration_ticket($migr_file, "$app_full_name");
        if ( $ticket ){
            my $migr_text = delete $files->{$migr_file};
            push @$migr_tickets_all, $ticket->{key};
            ### если миграция есть, но текст неактуальный -- надо обновлять текст
            if ( $ticket->{description} ne "%%\n$migr_text\n%%" ){
                $migr_tickets_to_update->{$ticket->{key}} = $migr_text;
            }
        }
    }

    return {
        migration_files => $files,
        migration_tickets_all => $migr_tickets_all,
        migration_tickets_to_update => $migr_tickets_to_update,
        migration_warning => $warning,
    };
}


sub find_migration_ticket
{
    my ($migr_file, $app) = @_;
    # TODO для Модерации -- либо своя очередь, либо DIRECTMOD + компонента
    my $issues = $st->get( query => qq!Queue: DIRECTMIGR Summary: #"$app: Миграция $migr_file"!, array => 1);
    if (scalar @$issues == 0){
        return '';
    } elsif ( scalar @$issues == 1 ) {
        return $issues->[0];
    } elsif (scalar @$issues > 1){
        die "only one ticket should be created for a migration ($migr_file), found ".(scalar @$issues).": ".join(", ", (map {$_->{key}} @$issues));
    } else {
        die "can't be";
    }
}

1;
