#!/usr/bin/python
# -*- coding: utf8 -*-

import os
import sys
import glob
import re

TEST_DIR = os.path.dirname(os.path.realpath(__file__))
sys.path.append(TEST_DIR + '/../bin')

import unittest
import importlib
dal = importlib.import_module("direct-arc-log-old")
import xml.etree.ElementTree as ET
from subprocess import CalledProcessError

class TestArcLogMethods(unittest.TestCase):

    def text_file_tests(self, in_file):
        """
        Удаляет неинтересные коммиты из файла tests/NAME_in.xml и сравнивает результат с содержимым файла tests/NAME_out.xml
        """
        tc_name = re.sub('^.*t.py/tests/correct/(.*)_in.xml$', '\g<1>', in_file)
        out_file = re.sub(r'_in.xml$', '_out.xml', in_file)

        in_log = ET.parse(in_file).getroot()
        in_log_filtered = dal.filter_commits(in_log, 'java-api5')
        out_log = ET.parse(out_file).getroot()
        #self.longMessage = True
        self.assertEqual(dal.xml_log_to_text(in_log_filtered), dal.xml_log_to_text(out_log), "test '%s'" % tc_name)

    def test_date_process(self):
        """
        Проверка корректного приведения utc к местному времени.
        """
        self.assertEqual(dal.process_date('2017-07-17T21:12:19.592666Z'), '2017-07-18 00:12:19')
        self.assertEqual(dal.process_date('2020-02-28T23:59:59.210961Z'), '2020-02-29 02:59:59')
        self.assertEqual(dal.process_date('2018-02-28T23:59:59.210961Z'), '2018-03-01 02:59:59')
        self.assertEqual(dal.process_date('2017-07-18T15:00:00.410961Z'), '2017-07-18 18:00:00')

    def test_external_cases(self):
        os.environ['APPS_CONF'] = TEST_DIR + '/test.apps.conf.yaml'
        for file in glob.glob(TEST_DIR + "/tests/correct/*_in.xml"):
            self.text_file_tests(file)

    def test_parse_log_error(self):
        """
        Генерируется ли исключение в случае неккоретного xml лога
        """
        with self.assertRaises(ET.ParseError) as e:
            root = ET.parse(TEST_DIR + r'/tests/wrong_file_in.xml')

    def test_beauty_write_xml_empty_log(self):
        """
        Работает ли функция печати с пустым логом
        """
        log = ET.Element('log')
        dal.xml_log_to_text(log)
        log.clear()

if __name__ == '__main__':
    unittest.main()
